/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configmodel;

import biz.netcentric.cq.tools.actool.configmodel.Restriction;
import biz.netcentric.cq.tools.actool.dumpservice.AcDumpElement;
import biz.netcentric.cq.tools.actool.dumpservice.AcDumpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AceBean
implements AcDumpElement {
    public static final Logger LOG = LoggerFactory.getLogger(AceBean.class);
    private String principalName;
    private String authorizableId;
    private String jcrPath;
    private String actionsStringFromConfig;
    private String privilegesString;
    private String permission;
    private String[] actions;
    private List<Restriction> restrictions = new ArrayList<Restriction>();
    private boolean keepOrder = false;
    private String initialContent;
    private String configSource;
    public static final String RESTRICTION_NAME_GLOB = "rep:glob";

    public AceBean clone() {
        AceBean clone = new AceBean();
        clone.setJcrPath(this.jcrPath);
        clone.setPrivilegesString(this.privilegesString);
        clone.setAuthorizableId(this.authorizableId);
        clone.setPrincipalName(this.principalName);
        clone.setPermission(this.permission);
        clone.setActions(this.actions);
        clone.setRestrictions(new ArrayList<Restriction>(this.restrictions));
        clone.setInitialContent(this.initialContent);
        clone.setKeepOrder(this.keepOrder);
        clone.setConfigSource(this.configSource + " (cloned)");
        return clone;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permissionString) {
        this.permission = permissionString;
    }

    public void clearActions() {
        this.actions = null;
        this.actionsStringFromConfig = "";
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public String getAuthorizableId() {
        return this.authorizableId;
    }

    public void setAuthorizableId(String authorizableId) {
        this.authorizableId = authorizableId;
    }

    public String getJcrPath() {
        return this.jcrPath;
    }

    public String getJcrPathForPolicyApi() {
        if (StringUtils.isBlank((CharSequence)this.jcrPath)) {
            return null;
        }
        return this.jcrPath;
    }

    public void setJcrPath(String jcrPath) {
        this.jcrPath = jcrPath;
    }

    public boolean isAllow() {
        return "allow".equalsIgnoreCase(this.permission);
    }

    public List<Restriction> getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(Object restrictionsRaw, String oldStyleRepGlob) {
        this.restrictions.clear();
        if (restrictionsRaw != null) {
            if (!(restrictionsRaw instanceof Map)) {
                throw new IllegalArgumentException("If 'restrictions' is provided for an AC entry, it needs to be a map.");
            }
            Map restrictionsMap = (Map)restrictionsRaw;
            for (String key : restrictionsMap.keySet()) {
                String value = (String)restrictionsMap.get(key);
                if (value == null) {
                    LOG.debug("Could not get value from restriction map using key: {}", (Object)key);
                    continue;
                }
                String[] values = value.split(" *, *");
                this.restrictions.add(new Restriction(key, values));
            }
        }
        if (oldStyleRepGlob != null) {
            if (this.containsRestriction(RESTRICTION_NAME_GLOB)) {
                throw new IllegalArgumentException("Usage of restrictions -> rep:glob and repGlob on top level cannot be mixed.");
            }
            this.restrictions.add(new Restriction(RESTRICTION_NAME_GLOB, oldStyleRepGlob));
        }
    }

    public boolean containsRestriction(String restrictionName) {
        for (Restriction currentRestriction : this.restrictions) {
            if (!StringUtils.equals((CharSequence)currentRestriction.getName(), (CharSequence)restrictionName)) continue;
            return true;
        }
        return false;
    }

    public void setRestrictions(List<Restriction> restrictions) {
        this.restrictions = restrictions;
    }

    public String getRepGlob() {
        for (Restriction currentRestriction : this.restrictions) {
            if (!StringUtils.equals((CharSequence)currentRestriction.getName(), (CharSequence)RESTRICTION_NAME_GLOB)) continue;
            return currentRestriction.getValue();
        }
        return null;
    }

    public String getActionsString() {
        if (this.actions != null) {
            StringBuilder sb = new StringBuilder();
            for (String action : this.actions) {
                sb.append(action).append(",");
            }
            return StringUtils.chomp((String)sb.toString(), (String)",");
        }
        return "";
    }

    public void setActions(String[] actions) {
        this.actions = actions;
    }

    public String[] getActions() {
        return this.actions;
    }

    public String getPrivilegesString() {
        return this.privilegesString;
    }

    public String[] getPrivileges() {
        if (StringUtils.isNotBlank((CharSequence)this.privilegesString)) {
            return this.privilegesString.split(" *, *");
        }
        return null;
    }

    public void setPrivilegesString(String privilegesString) {
        this.privilegesString = privilegesString;
    }

    public String getInitialContent() {
        return this.initialContent;
    }

    public void setInitialContent(String initialContent) {
        this.initialContent = initialContent;
    }

    public boolean isKeepOrder() {
        return this.keepOrder;
    }

    public void setKeepOrder(boolean keepOrder) {
        this.keepOrder = keepOrder;
    }

    public String toString() {
        return "AceBean [\n  jcrPath=" + this.jcrPath + "\n, actionsStringFromConfig=" + this.actionsStringFromConfig + "\n, privilegesString=" + this.privilegesString + "\n, principal=" + this.principalName + "\n, authorizableId=" + this.authorizableId + "\n, permission=" + this.permission + "\n, actions=" + Arrays.toString(this.actions) + "\n, restrictions=" + String.valueOf(this.restrictions) + "\n, initialContent=" + this.initialContent + "\n, configSource=" + this.configSource + "]";
    }

    public String getConfigSource() {
        return this.configSource;
    }

    public void setConfigSource(String configSource) {
        this.configSource = configSource;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.actions);
        result = 31 * result + (this.actionsStringFromConfig == null ? 0 : this.actionsStringFromConfig.hashCode());
        result = 31 * result + (this.initialContent == null ? 0 : this.initialContent.hashCode());
        result = 31 * result + (this.jcrPath == null ? 0 : this.jcrPath.hashCode());
        result = 31 * result + (this.permission == null ? 0 : this.permission.hashCode());
        result = 31 * result + (this.authorizableId == null ? 0 : this.authorizableId.hashCode());
        result = 31 * result + (this.principalName == null ? 0 : this.principalName.hashCode());
        result = 31 * result + (this.privilegesString == null ? 0 : this.privilegesString.hashCode());
        result = 31 * result + (this.restrictions == null ? 0 : this.restrictions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AceBean other = (AceBean)obj;
        if (!Arrays.equals(this.actions, other.actions)) {
            return false;
        }
        if (this.actionsStringFromConfig == null ? other.actionsStringFromConfig != null : !this.actionsStringFromConfig.equals(other.actionsStringFromConfig)) {
            return false;
        }
        if (this.initialContent == null ? other.initialContent != null : !this.initialContent.equals(other.initialContent)) {
            return false;
        }
        if (this.jcrPath == null ? other.jcrPath != null : !this.jcrPath.equals(other.jcrPath)) {
            return false;
        }
        if (this.permission == null ? other.permission != null : !this.permission.equals(other.permission)) {
            return false;
        }
        if (this.principalName == null ? other.principalName != null : !this.principalName.equals(other.principalName)) {
            return false;
        }
        if (this.authorizableId == null ? other.authorizableId != null : !this.authorizableId.equals(other.authorizableId)) {
            return false;
        }
        if (this.privilegesString == null ? other.privilegesString != null : !this.privilegesString.equals(other.privilegesString)) {
            return false;
        }
        return !(this.restrictions == null ? other.restrictions != null : !this.restrictions.equals(other.restrictions));
    }

    @Override
    public void accept(AcDumpElementVisitor acDumpElementVisitor) {
        acDumpElementVisitor.visit(this);
    }

    public Map<String, Boolean> getActionMap() {
        if (this.actions == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Boolean> actionMap = new HashMap<String, Boolean>();
        for (String action : this.actions) {
            actionMap.put(action, this.isAllow());
        }
        return actionMap;
    }

    public boolean isInitialContentOnlyConfig() {
        return StringUtils.isNotBlank((CharSequence)this.initialContent) && StringUtils.isBlank((CharSequence)this.permission) && StringUtils.isBlank((CharSequence)this.privilegesString) && StringUtils.isBlank((CharSequence)this.actionsStringFromConfig);
    }
}

