/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configmodel;

import biz.netcentric.cq.tools.actool.configmodel.GlobalConfiguration;
import biz.netcentric.cq.tools.actool.configmodel.pkcs.Key;
import biz.netcentric.cq.tools.actool.dumpservice.AcDumpElement;
import biz.netcentric.cq.tools.actool.dumpservice.AcDumpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class AuthorizableConfigBean
implements AcDumpElement {
    private String authorizableId;
    private String principalName;
    private String name;
    private String email;
    private String description;
    private String[] isMemberOf;
    private String[] members;
    private String path;
    private String password;
    private String externalId;
    private String profileContent;
    private String preferencesContent;
    private String socialContent;
    private String migrateFrom;
    private String unmanagedAcePathsRegex;
    private Pattern unmanagedExternalIsMemberOfRegex;
    private Pattern unmanagedExternalMembersRegex;
    private boolean isGroup = true;
    private boolean isSystemUser = false;
    private String disabled;
    private boolean virtual;
    private boolean appendToKeyStore;
    private String keyStorePassword;
    private Map<String, Key> keys;
    private List<String> impersonationAllowedFor;
    private boolean externalSync;

    public String getAuthorizableId() {
        return this.authorizableId;
    }

    public void setAuthorizableId(String authorizableId) {
        this.authorizableId = authorizableId;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getProfileContent() {
        return this.profileContent;
    }

    public void setProfileContent(String profileContent) {
        this.profileContent = profileContent;
    }

    public String getPreferencesContent() {
        return this.preferencesContent;
    }

    public void setPreferencesContent(String preferencesContent) {
        this.preferencesContent = preferencesContent;
    }

    public String getSocialContent() {
        return this.socialContent;
    }

    public void setSocialContent(String socialContent) {
        this.socialContent = socialContent;
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public void setIsGroup(boolean isGroup) {
        this.isGroup = isGroup;
    }

    public boolean isSystemUser() {
        return this.isSystemUser;
    }

    public void setIsSystemUser(boolean isSystemUser) {
        this.isSystemUser = isSystemUser;
    }

    public String[] getIsMemberOf() {
        return this.isMemberOf;
    }

    public boolean isMemberOfOtherGroups() {
        return this.isMemberOf != null;
    }

    public String getIsMemberOfString() {
        if (this.isMemberOf == null) {
            return "";
        }
        return StringUtils.join((Object[])this.isMemberOf, (String)",");
    }

    public void setIsMemberOf(String[] memberOf) {
        this.isMemberOf = memberOf;
    }

    public void setIsMemberOf(List<String> memberOf) {
        this.isMemberOf = memberOf != null ? memberOf.toArray(new String[memberOf.size()]) : null;
    }

    public void addIsMemberOf(String member) {
        if (this.isMemberOf == null) {
            this.isMemberOf = new String[]{member};
            return;
        }
        ArrayList<String> memberList = new ArrayList<String>();
        memberList.addAll(Arrays.asList(this.isMemberOf));
        if (!memberList.contains(member)) {
            memberList.add(member);
            this.isMemberOf = memberList.toArray(new String[memberList.size()]);
        }
    }

    public String getMembersString() {
        if (this.members == null) {
            return "";
        }
        StringBuilder membersString = new StringBuilder();
        for (String group : this.members) {
            membersString.append(group).append(",");
        }
        return StringUtils.chop((String)membersString.toString());
    }

    public String[] getMembers() {
        return this.members;
    }

    public void setMembers(String[] members) {
        this.members = members;
    }

    public String getDisabled() {
        return this.disabled;
    }

    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    public String getMigrateFrom() {
        return this.migrateFrom;
    }

    public void setMigrateFrom(String migrateFrom) {
        this.migrateFrom = migrateFrom;
    }

    public String getUnmanagedAcePathsRegex() {
        return this.unmanagedAcePathsRegex;
    }

    public void setUnmanagedAcePathsRegex(String unmanagedAcePathsRegex) {
        this.unmanagedAcePathsRegex = unmanagedAcePathsRegex;
    }

    public Pattern getUnmanagedExternalIsMemberOfRegex() {
        return this.unmanagedExternalIsMemberOfRegex;
    }

    public void setUnmanagedExternalIsMemberOfRegex(String unmanagedExternalIsMemberOfRegex) {
        this.unmanagedExternalIsMemberOfRegex = GlobalConfiguration.stringToRegex(unmanagedExternalIsMemberOfRegex);
    }

    public Pattern getUnmanagedExternalMembersRegex() {
        return this.unmanagedExternalMembersRegex;
    }

    public void setUnmanagedExternalMembersRegex(String unmanagedExternalMembersRegex) {
        this.unmanagedExternalMembersRegex = GlobalConfiguration.stringToRegex(unmanagedExternalMembersRegex);
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public Map<String, Key> getKeys() {
        return this.keys;
    }

    public void setKeys(Map<String, Key> keys) {
        this.keys = keys;
    }

    public boolean isAppendToKeyStore() {
        return this.appendToKeyStore;
    }

    public void setAppendToKeyStore(boolean appendToKeyStore) {
        this.appendToKeyStore = appendToKeyStore;
    }

    public List<String> getImpersonationAllowedFor() {
        return this.impersonationAllowedFor;
    }

    public void setImpersonationAllowedFor(List<String> impersonationAllowedFor) {
        this.impersonationAllowedFor = impersonationAllowedFor;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nid: " + this.authorizableId + "\n");
        sb.append("name: " + this.principalName + "\n");
        sb.append("path: " + this.path + "\n");
        sb.append("isMemberOf: " + this.getIsMemberOfString() + "\n");
        sb.append("members: " + this.getMembersString() + "\n");
        sb.append("appendToKeyStore: " + this.isAppendToKeyStore() + "\n");
        sb.append("keys:" + String.valueOf(this.getKeys()) + "\n");
        sb.append("impersonationAllowedFor:" + String.valueOf(this.getImpersonationAllowedFor()) + "\n");
        sb.append("externalSync: " + this.isExternalSync());
        return sb.toString();
    }

    public boolean managesPath(String path, String defaultUnmanagedAcePathsRegex) {
        String effectiveUnmanagedAcePathsRegex = (String)StringUtils.defaultIfEmpty((CharSequence)this.unmanagedAcePathsRegex, (CharSequence)defaultUnmanagedAcePathsRegex);
        if (StringUtils.isNotBlank((CharSequence)effectiveUnmanagedAcePathsRegex) && StringUtils.isNotBlank((CharSequence)path)) {
            boolean pathIsManaged = !path.matches(effectiveUnmanagedAcePathsRegex);
            return pathIsManaged;
        }
        return true;
    }

    @Override
    public void accept(AcDumpElementVisitor acDumpElementVisitor) {
        acDumpElementVisitor.visit(this);
    }

    public boolean isExternalSync() {
        return this.externalSync;
    }

    public void setExternalSync(boolean externalSync) {
        this.externalSync = externalSync;
    }

    public Map<String, Object> getVariablesForInterpolation() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        HashMap<String, String> groupVar = new HashMap<String, String>();
        String groupId = this.getAuthorizableId();
        groupVar.put("id", groupId);
        groupVar.put("name", (String)StringUtils.defaultIfEmpty((CharSequence)this.getName(), (CharSequence)groupId));
        groupVar.put("path", this.getPath());
        vars.put("group", groupVar);
        return vars;
    }
}

