/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configmodel.pkcs;

import biz.netcentric.cq.tools.actool.configmodel.pkcs.DerType;
import java.security.InvalidKeyException;
import java.util.regex.Pattern;

public class DerData {
    final byte[] data;
    final DerType type;
    static final Pattern PUBLIC_KEY_PATTERN = Pattern.compile("-+BEGIN PUBLIC KEY[^-]*-+(?:\\s)+([a-z0-9+/=\\s]+)-+END PUBLIC KEY[^-]*-+", 2);
    static final Pattern PRIVATE_KEY_PATTERN = Pattern.compile("-+BEGIN PRIVATE KEY[^-]*-+(?:\\s)+([a-z0-9+/=\\s]+)-+END PRIVATE KEY[^-]*-+", 2);
    static final Pattern ENCRYPTED_PRIVATE_KEY_PATTERN = Pattern.compile("-+BEGIN ENCRYPTED PRIVATE KEY[^-]*-+(?:\\s)+([a-z0-9+/=\\s]+)-+END ENCRYPTED PRIVATE KEY[^-]*-+", 2);
    static final Pattern CERTIFICATE_PATTERN = Pattern.compile("-+BEGIN CERTIFICATE[^-]*-+(?:\\s)+([a-z0-9+/=\\s]+)-+END CERTIFICATE[^-]*-+", 2);

    public DerData(byte[] data, DerType type) {
        this.data = data;
        this.type = type;
    }

    public byte[] getData() {
        return this.data;
    }

    public DerType getType() {
        return this.type;
    }

    static DerData parseFromPem(String pem) throws InvalidKeyException {
        for (DerType type : DerType.values()) {
            byte[] data = type.fromPem(pem);
            if (data == null) continue;
            return new DerData(data, type);
        }
        throw new InvalidKeyException("No supported PEM format as defined in https://tools.ietf.org/html/rfc7468 detected!");
    }
}

