/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configreader;

import biz.netcentric.cq.tools.actool.configmodel.AcConfiguration;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizablesConfig;
import biz.netcentric.cq.tools.actool.configmodel.AutoCreateTestUsersConfig;
import biz.netcentric.cq.tools.actool.configreader.YamlMacroElEvaluator;
import biz.netcentric.cq.tools.actool.crypto.DecryptionService;
import biz.netcentric.cq.tools.actool.history.InstallationLogger;
import biz.netcentric.cq.tools.actool.slingsettings.ExtendedSlingSettingsService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={TestUserConfigsCreator.class})
public class TestUserConfigsCreator {
    private static final Logger LOG = LoggerFactory.getLogger(TestUserConfigsCreator.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    ExtendedSlingSettingsService slingSettingsService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    DecryptionService decryptionService;
    YamlMacroElEvaluator elEvaluator = null;

    public boolean isSkippedForRunmode(List<String> skipForRunmodes) {
        return this.slingSettingsService != null && !CollectionUtils.intersection(this.slingSettingsService.getRunModes(), skipForRunmodes).isEmpty();
    }

    void createTestUserConfigs(AcConfiguration acConfiguration, InstallationLogger logger) {
        AutoCreateTestUsersConfig autoCreateTestUsersConf = acConfiguration.getGlobalConfiguration().getAutoCreateTestUsersConfig();
        if (autoCreateTestUsersConf == null) {
            return;
        }
        if (this.isSkippedForRunmode(autoCreateTestUsersConf.getSkipForRunmodes())) {
            return;
        }
        ArrayList<AuthorizableConfigBean> testUserConfigBeansToAdd = new ArrayList<AuthorizableConfigBean>();
        AuthorizablesConfig authorizablesConfig = acConfiguration.getAuthorizablesConfig();
        for (AuthorizableConfigBean groupAuthConfigBean : authorizablesConfig) {
            Object password;
            if (!groupAuthConfigBean.isGroup()) continue;
            String groupId = groupAuthConfigBean.getAuthorizableId();
            Pattern pattern = Pattern.compile(autoCreateTestUsersConf.getCreateForGroupNamesRegEx());
            Matcher matcher = pattern.matcher(groupId);
            if (!matcher.matches()) continue;
            Map<String, Object> vars = groupAuthConfigBean.getVariablesForInterpolation();
            vars.putAll(this.getVarsForCapturedGroups(matcher));
            AuthorizableConfigBean testUserConfigBean = new AuthorizableConfigBean();
            testUserConfigBean.setIsGroup(false);
            String testUserAuthId = autoCreateTestUsersConf.getPrefix() + groupId;
            testUserConfigBean.setAuthorizableId(testUserAuthId);
            testUserConfigBean.setPath(autoCreateTestUsersConf.getPath());
            testUserConfigBean.setIsMemberOf(new String[]{groupId});
            testUserConfigBean.setImpersonationAllowedFor(autoCreateTestUsersConf.getImpersonationAllowedFor());
            String name = (String)StringUtils.defaultIfEmpty((CharSequence)autoCreateTestUsersConf.getName(), (CharSequence)"Test User %{group.name}");
            testUserConfigBean.setName(this.processValue(name, vars));
            if (StringUtils.isNotBlank((CharSequence)autoCreateTestUsersConf.getEmail())) {
                testUserConfigBean.setEmail(this.processValue(autoCreateTestUsersConf.getEmail(), vars));
            }
            if (StringUtils.isNotBlank((CharSequence)autoCreateTestUsersConf.getDescription())) {
                testUserConfigBean.setDescription(this.processValue(autoCreateTestUsersConf.getDescription(), vars));
            }
            password = StringUtils.isNotBlank((CharSequence)(password = autoCreateTestUsersConf.getPassword())) ? this.processValue((String)password, vars) : testUserAuthId;
            try {
                password = this.decryptionService.decrypt((String)password);
            }
            catch (UnsupportedOperationException e) {
                throw new IllegalArgumentException("Could not unprotect password " + (String)password + " as given in autoCreateTestUsers");
            }
            testUserConfigBean.setPassword((String)password);
            testUserConfigBeansToAdd.add(testUserConfigBean);
        }
        authorizablesConfig.addAll(testUserConfigBeansToAdd);
        logger.addMessage(LOG, "Created  " + testUserConfigBeansToAdd.size() + " test user configs at path " + autoCreateTestUsersConf.getPath() + " (for groups matching " + autoCreateTestUsersConf.getCreateForGroupNamesRegEx() + ")");
    }

    Map<String, Object> getVarsForCapturedGroups(Matcher matcher) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        for (int i = 0; i <= matcher.groupCount(); ++i) {
            vars.put("cg" + i, matcher.group(i));
        }
        return vars;
    }

    String processValue(String value, Map<? extends Object, ? extends Object> variables) {
        if (this.elEvaluator == null) {
            this.elEvaluator = new YamlMacroElEvaluator();
        }
        return this.elEvaluator.evaluateElWithPercentSyntax(value, String.class, variables);
    }
}

