/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configreader;

import biz.netcentric.cq.tools.actool.configmodel.AceBean;
import biz.netcentric.cq.tools.actool.configmodel.AcesConfig;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizablesConfig;
import biz.netcentric.cq.tools.actool.configmodel.GlobalConfiguration;
import biz.netcentric.cq.tools.actool.configmodel.pkcs.Key;
import biz.netcentric.cq.tools.actool.configmodel.pkcs.PrivateKeyDecryptor;
import biz.netcentric.cq.tools.actool.configreader.ConfigReader;
import biz.netcentric.cq.tools.actool.crypto.DecryptionService;
import biz.netcentric.cq.tools.actool.helper.QueryHelper;
import biz.netcentric.cq.tools.actool.validators.AceBeanValidator;
import biz.netcentric.cq.tools.actool.validators.AuthorizableValidator;
import biz.netcentric.cq.tools.actool.validators.exceptions.AcConfigBeanValidationException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidAuthorizableException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class YamlConfigReader
implements ConfigReader {
    private static final Logger LOG = LoggerFactory.getLogger(YamlConfigReader.class);
    protected static final String ACE_CONFIG_PROPERTY_GLOB = "repGlob";
    protected static final String ACE_CONFIG_PROPERTY_RESTRICTIONS = "restrictions";
    protected static final String ACE_CONFIG_PROPERTY_PERMISSION = "permission";
    protected static final String ACE_CONFIG_PROPERTY_PRIVILEGES = "privileges";
    protected static final String ACE_CONFIG_PROPERTY_ACTIONS = "actions";
    protected static final String ACE_CONFIG_PROPERTY_PATH = "path";
    protected static final String ACE_CONFIG_PROPERTY_KEEP_ORDER = "keepOrder";
    protected static final String ACE_CONFIG_INITIAL_CONTENT = "initialContent";
    private static final String GROUP_CONFIG_PROPERTY_IS_MEMBER_OF = "isMemberOf";
    private static final String GROUP_CONFIG_PROPERTY_MEMBER_OF_LEGACY = "memberOf";
    private static final String GROUP_CONFIG_PROPERTY_MEMBERS = "members";
    private static final String GROUP_CONFIG_PROPERTY_PATH = "path";
    private static final String GROUP_CONFIG_PROPERTY_PASSWORD = "password";
    protected static final String GROUP_CONFIG_PROPERTY_NAME = "name";
    private static final String GROUP_CONFIG_PROPERTY_DESCRIPTION = "description";
    private static final String GROUP_CONFIG_PROPERTY_EXTERNAL_ID = "externalId";
    private static final String GROUP_CONFIG_PROPERTY_MIGRATE_FROM = "migrateFrom";
    private static final String GROUP_CONFIG_PROPERTY_UNMANAGED_ACE_PATHS_REGEX = "unmanagedAcePathsRegex";
    private static final String GROUP_CONFIG_PROPERTY_UNMANAGED_EXTERNAL_ISMEMBEROF_REGEX = "unmanagedExternalIsMemberOfRegex";
    private static final String GROUP_CONFIG_PROPERTY_UNMANAGED_EXTERNAL_MEMBERS_REGEX = "unmanagedExternalMembersRegex";
    private static final String GROUP_CONFIG_IS_VIRTUAL = "virtual";
    private static final String GROUP_CONFIG_EXTERNAL_SYNC = "externalSync";
    private static final String USER_CONFIG_PROPERTY_IS_SYSTEM_USER = "isSystemUser";
    private static final String USER_CONFIG_PROFILE_CONTENT = "profileContent";
    private static final String USER_CONFIG_PREFERENCES_CONTENT = "preferencesContent";
    private static final String USER_CONFIG_SOCIAL_CONTENT = "socialContent";
    private static final String USER_CONFIG_PROPERTY_EMAIL = "email";
    private static final String USER_CONFIG_DISABLED = "disabled";
    private static final String USER_CONFIG_KEYS = "keys";
    private static final String USER_CONFIG_APPEND_TO_KEYSTORE = "appendToKeyStore";
    private static final String USER_CONFIG_KEYSTORE_PASSWORD = "keyStorePassword";
    private static final String USER_CONFIG_KEY_PUBLIC = "public";
    private static final String USER_CONFIG_KEY_PRIVATE_PASSWORD = "privatePassword";
    private static final String USER_CONFIG_KEY_PRIVATE = "private";
    private static final String USER_CONFIG_KEY_CERTIFICATE = "certificate";
    private static final String USER_CONFIG_IMPERSONATION_ALLOWED_FOR = "impersonationAllowedFor";
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private SlingRepository repository;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    DecryptionService decryptionService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    PrivateKeyDecryptor privateKeyDecryptor;

    @Override
    public AcesConfig getAceConfigurationBeans(Collection<?> aceConfigData, AceBeanValidator aceBeanValidator, Session session, String sourceFile) throws RepositoryException, AcConfigBeanValidationException {
        List aclList = (List)this.getConfigSection("ace_config", aceConfigData);
        if (aclList == null) {
            LOG.debug("ACL configuration not found in this YAML configuration file");
            return null;
        }
        AcesConfig aceMapFromConfig = this.getPreservedOrderdAceSet(aclList, aceBeanValidator, session, sourceFile);
        return aceMapFromConfig;
    }

    public AuthorizablesConfig getGroupConfigurationBeans(Collection yamlList, AuthorizableValidator authorizableValidator) throws AcConfigBeanValidationException {
        List authorizableList = (List)this.getConfigSection("group_config", yamlList);
        if (authorizableList == null) {
            LOG.debug("Group configuration not found in this YAML configuration file");
            return null;
        }
        AuthorizablesConfig authorizableBeans = this.getAuthorizableBeans(authorizableList, authorizableValidator, true);
        return authorizableBeans;
    }

    public AuthorizablesConfig getUserConfigurationBeans(Collection yamlList, AuthorizableValidator authorizableValidator) throws AcConfigBeanValidationException {
        List authorizableList = (List)this.getConfigSection("user_config", yamlList);
        AuthorizablesConfig authorizableBeans = this.getAuthorizableBeans(authorizableList, authorizableValidator, false);
        return authorizableBeans;
    }

    @Override
    public GlobalConfiguration getGlobalConfiguration(Collection yamlList) {
        Map globalConfigMap = (Map)this.getConfigSection("global_config", yamlList);
        GlobalConfiguration globalConfiguration = new GlobalConfiguration(globalConfigMap);
        return globalConfiguration;
    }

    @Override
    public Set<String> getObsoluteAuthorizables(Collection yamlList) {
        List obsoleteAuthorizablesList = (List)this.getConfigSection("obsolete_authorizables", yamlList);
        HashSet<String> obsoleteAuthorizables = new HashSet<String>();
        if (obsoleteAuthorizablesList != null) {
            for (Object obsoleteAuthorizable : obsoleteAuthorizablesList) {
                if (obsoleteAuthorizable instanceof String) {
                    obsoleteAuthorizables.add((String)obsoleteAuthorizable);
                    continue;
                }
                if (!(obsoleteAuthorizable instanceof Map)) continue;
                Map map = (Map)obsoleteAuthorizable;
                obsoleteAuthorizables.add((String)map.keySet().iterator().next());
            }
        }
        return obsoleteAuthorizables;
    }

    private Object getConfigSection(String sectionName, Collection yamlList) {
        ArrayList yamList = new ArrayList(yamlList);
        for (LinkedHashMap currMap : yamList) {
            Iterator keyIt = currMap.keySet().iterator();
            if (!keyIt.hasNext() || !sectionName.equals(keyIt.next())) continue;
            return currMap.get(sectionName);
        }
        return null;
    }

    private AuthorizablesConfig getAuthorizableBeans(List<LinkedHashMap> yamlMap, AuthorizableValidator authorizableValidator, boolean isGroupSection) throws AcConfigBeanValidationException {
        HashSet<String> alreadyProcessedGroups = new HashSet<String>();
        AuthorizablesConfig authorizableBeans = new AuthorizablesConfig();
        if (yamlMap == null) {
            return authorizableBeans;
        }
        for (LinkedHashMap currentMap : yamlMap) {
            String currentAuthorizableIdFromYaml = (String)currentMap.keySet().iterator().next();
            if (!alreadyProcessedGroups.add(currentAuthorizableIdFromYaml)) {
                throw new IllegalArgumentException("There is more than one group definition for group: " + currentAuthorizableIdFromYaml);
            }
            LOG.trace("Found principal: {} in config", (Object)currentAuthorizableIdFromYaml);
            List currentAuthorizableData = (List)currentMap.get(currentAuthorizableIdFromYaml);
            if (currentAuthorizableData == null || currentAuthorizableData.isEmpty()) continue;
            if (currentAuthorizableData.size() > 1) {
                throw new AcConfigBeanValidationException("Invalid authorizable " + currentAuthorizableIdFromYaml + " - configuration needs to contain exactly one yaml list entry");
            }
            try {
                Map currentPrincipalDataMap = (Map)currentAuthorizableData.get(0);
                AuthorizableConfigBean tmpPrincipalConfigBean = this.getNewAuthorizableConfigBean();
                this.setupAuthorizableBean(tmpPrincipalConfigBean, currentPrincipalDataMap, currentAuthorizableIdFromYaml, isGroupSection);
                if (authorizableValidator != null) {
                    authorizableValidator.validate(tmpPrincipalConfigBean);
                }
                authorizableBeans.add(tmpPrincipalConfigBean);
            }
            catch (AcConfigBeanValidationException e) {
                throw new AcConfigBeanValidationException("Invalid authorizable " + currentAuthorizableIdFromYaml, e);
            }
        }
        return authorizableBeans;
    }

    private AcesConfig getPreservedOrderdAceSet(List<LinkedHashMap> aceYamlList, AceBeanValidator aceBeanValidator, Session session, String sourceFile) throws RepositoryException, AcConfigBeanValidationException {
        AcesConfig aceSet = new AcesConfig();
        if (aceYamlList == null) {
            return aceSet;
        }
        for (Map map : aceYamlList) {
            String authorizableId = (String)map.keySet().iterator().next();
            List aceDefinitions = (List)map.get(authorizableId);
            LOG.trace("Start reading ACE configuration of authorizable: {}", (Object)authorizableId);
            if (aceDefinitions == null || aceDefinitions.isEmpty()) {
                LOG.warn("No ACE definition(s) found for authorizable: {}", (Object)authorizableId);
                continue;
            }
            for (Map currentAceDefinition : aceDefinitions) {
                AceBean newAceBean = this.getNewAceBean();
                this.setupAceBean(authorizableId, currentAceDefinition, newAceBean, sourceFile);
                if (aceBeanValidator != null) {
                    aceBeanValidator.validate(newAceBean, session.getAccessControlManager());
                }
                if (newAceBean.getJcrPath() != null && newAceBean.getJcrPath().contains("*") && null != session) {
                    this.handleWildcards(session, aceSet, authorizableId, newAceBean);
                    continue;
                }
                aceSet.add(newAceBean);
            }
        }
        return aceSet;
    }

    protected void handleWildcards(Session session, Set<AceBean> aceSet, String principal, AceBean tmpAclBean) throws InvalidQueryException, RepositoryException {
        String query = YamlConfigReader.createXPathQueryForPathWithWildcards(tmpAclBean.getJcrPath());
        Set<String> result = QueryHelper.getNodePathsFromQuery(session, query);
        if (result.isEmpty()) {
            return;
        }
        for (String path : result) {
            if (path.contains("/rep:policy")) continue;
            AceBean replacementBean = tmpAclBean.clone();
            replacementBean.setJcrPath(path);
            if (aceSet.add(replacementBean)) {
                LOG.info("Wildcard replacement: Cloned " + String.valueOf(tmpAclBean) + " to " + String.valueOf(replacementBean));
                continue;
            }
            LOG.warn("Wildcard replacement failed: Cloned " + String.valueOf(tmpAclBean) + " to " + String.valueOf(replacementBean) + " but bean was already in set");
        }
    }

    static final String createXPathQueryForPathWithWildcards(String jcrPathWithWildcard) {
        String query = "/jcr:root" + ISO9075.encodePath((String)jcrPathWithWildcard);
        return query.replace("_x002a_", "*");
    }

    protected AceBean getNewAceBean() {
        return new AceBean();
    }

    protected AuthorizableConfigBean getNewAuthorizableConfigBean() {
        return new AuthorizableConfigBean();
    }

    protected void setupAceBean(String authorizableId, Map<String, ?> currentAceDefinition, AceBean aclBean, String sourceFile) {
        aclBean.setAuthorizableId(authorizableId);
        aclBean.setPrincipalName(authorizableId);
        String jcrPath = this.getMapValueAsString(currentAceDefinition, "path").trim();
        jcrPath = !jcrPath.equals("/") && jcrPath.endsWith("/") ? StringUtils.removeEnd((String)jcrPath, (String)"/") : jcrPath;
        aclBean.setJcrPath(jcrPath);
        aclBean.setPrivilegesString(this.getMapValueAsString(currentAceDefinition, ACE_CONFIG_PROPERTY_PRIVILEGES));
        aclBean.setPermission(this.getMapValueAsString(currentAceDefinition, ACE_CONFIG_PROPERTY_PERMISSION));
        aclBean.setRestrictions(currentAceDefinition.get(ACE_CONFIG_PROPERTY_RESTRICTIONS), (String)currentAceDefinition.get(ACE_CONFIG_PROPERTY_GLOB));
        aclBean.setActions(YamlConfigReader.parseActionsString(this.getMapValueAsString(currentAceDefinition, ACE_CONFIG_PROPERTY_ACTIONS)));
        aclBean.setKeepOrder(Boolean.valueOf(this.getMapValueAsString(currentAceDefinition, ACE_CONFIG_PROPERTY_KEEP_ORDER)));
        String initialContent = this.getMapValueAsString(currentAceDefinition, ACE_CONFIG_INITIAL_CONTENT);
        aclBean.setInitialContent(initialContent);
        aclBean.setConfigSource(sourceFile);
    }

    public static String[] parseActionsString(String actionsStringFromConfig) {
        String[] empty = new String[]{};
        return StringUtils.isNotBlank((CharSequence)actionsStringFromConfig) ? actionsStringFromConfig.split(",") : empty;
    }

    protected void setupAuthorizableBean(AuthorizableConfigBean authorizableConfigBean, Map<String, Object> currentPrincipalDataMap, String authorizableId, boolean isGroupSection) throws AcConfigBeanValidationException {
        String keystorePassword;
        Object isMemberOfVal;
        authorizableConfigBean.setAuthorizableId(authorizableId);
        authorizableConfigBean.setName(this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_PROPERTY_NAME));
        authorizableConfigBean.setEmail(this.getMapValueAsString(currentPrincipalDataMap, USER_CONFIG_PROPERTY_EMAIL));
        authorizableConfigBean.setDescription(this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_PROPERTY_DESCRIPTION));
        String externalIdVal = this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_PROPERTY_EXTERNAL_ID);
        if (StringUtils.isNotBlank((CharSequence)externalIdVal)) {
            authorizableConfigBean.setExternalId(externalIdVal);
            String principalName = StringUtils.substringBeforeLast((String)externalIdVal, (String)";");
            authorizableConfigBean.setPrincipalName(principalName);
        } else {
            authorizableConfigBean.setPrincipalName(authorizableId);
        }
        Object object = isMemberOfVal = currentPrincipalDataMap.containsKey(GROUP_CONFIG_PROPERTY_IS_MEMBER_OF) ? currentPrincipalDataMap.get(GROUP_CONFIG_PROPERTY_IS_MEMBER_OF) : currentPrincipalDataMap.get(GROUP_CONFIG_PROPERTY_MEMBER_OF_LEGACY);
        if (isMemberOfVal instanceof String) {
            authorizableConfigBean.setIsMemberOf(((String)isMemberOfVal).trim().split("\\s*,\\s*"));
        } else if (isMemberOfVal instanceof List) {
            authorizableConfigBean.setIsMemberOf((List)isMemberOfVal);
        }
        Object membersVal = currentPrincipalDataMap.get(GROUP_CONFIG_PROPERTY_MEMBERS);
        if (membersVal instanceof String) {
            authorizableConfigBean.setMembers(((String)membersVal).trim().split("\\s*,\\s*"));
        } else if (membersVal instanceof List) {
            List membersList = (List)membersVal;
            authorizableConfigBean.setMembers(membersList.toArray(new String[membersList.size()]));
        }
        authorizableConfigBean.setPath(YamlConfigReader.normalizePath(this.getMapValueAsString(currentPrincipalDataMap, "path")));
        authorizableConfigBean.setMigrateFrom(this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_PROPERTY_MIGRATE_FROM));
        authorizableConfigBean.setUnmanagedAcePathsRegex(this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_PROPERTY_UNMANAGED_ACE_PATHS_REGEX));
        authorizableConfigBean.setUnmanagedExternalIsMemberOfRegex(this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_PROPERTY_UNMANAGED_EXTERNAL_ISMEMBEROF_REGEX));
        authorizableConfigBean.setUnmanagedExternalMembersRegex(this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_PROPERTY_UNMANAGED_EXTERNAL_MEMBERS_REGEX));
        authorizableConfigBean.setVirtual(Boolean.valueOf(this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_IS_VIRTUAL)));
        authorizableConfigBean.setExternalSync(Boolean.valueOf(this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_EXTERNAL_SYNC)));
        authorizableConfigBean.setIsGroup(isGroupSection);
        authorizableConfigBean.setIsSystemUser(Boolean.valueOf(this.getMapValueAsString(currentPrincipalDataMap, USER_CONFIG_PROPERTY_IS_SYSTEM_USER)));
        if (currentPrincipalDataMap.containsKey(GROUP_CONFIG_PROPERTY_PASSWORD)) {
            authorizableConfigBean.setPassword(this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_PROPERTY_PASSWORD));
        }
        authorizableConfigBean.setProfileContent(this.getMapValueAsString(currentPrincipalDataMap, USER_CONFIG_PROFILE_CONTENT));
        authorizableConfigBean.setPreferencesContent(this.getMapValueAsString(currentPrincipalDataMap, USER_CONFIG_PREFERENCES_CONTENT));
        authorizableConfigBean.setSocialContent(this.getMapValueAsString(currentPrincipalDataMap, USER_CONFIG_SOCIAL_CONTENT));
        if (currentPrincipalDataMap.containsKey(USER_CONFIG_DISABLED)) {
            authorizableConfigBean.setDisabled(this.getMapValueAsString(currentPrincipalDataMap, USER_CONFIG_DISABLED));
        }
        authorizableConfigBean.setAppendToKeyStore(Boolean.valueOf(this.getMapValueAsString(currentPrincipalDataMap, USER_CONFIG_APPEND_TO_KEYSTORE)));
        if (currentPrincipalDataMap.containsKey(USER_CONFIG_KEYS)) {
            Object configObjUserConfigKeys = currentPrincipalDataMap.get(USER_CONFIG_KEYS);
            if (!(configObjUserConfigKeys instanceof Map)) {
                throw new InvalidAuthorizableException("Field 'keys' must be a map but is a " + String.valueOf(configObjUserConfigKeys.getClass()));
            }
            try {
                this.setupAuthorizableKeys(authorizableConfigBean, (Map)configObjUserConfigKeys);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new InvalidAuthorizableException("Invalid key format given", e);
            }
        }
        if (currentPrincipalDataMap.containsKey(USER_CONFIG_IMPERSONATION_ALLOWED_FOR)) {
            Object configObjImpersonationAllowedFor = currentPrincipalDataMap.get(USER_CONFIG_IMPERSONATION_ALLOWED_FOR);
            if (configObjImpersonationAllowedFor instanceof String) {
                authorizableConfigBean.setImpersonationAllowedFor(Arrays.asList(((String)configObjImpersonationAllowedFor).trim().split("\\s*,\\s*")));
            } else if (configObjImpersonationAllowedFor instanceof List) {
                authorizableConfigBean.setImpersonationAllowedFor((List)configObjImpersonationAllowedFor);
            } else {
                throw new InvalidAuthorizableException("Field 'impersonationAllowedFor' must be a list (yaml list or comma-separated string) but is a " + String.valueOf(configObjImpersonationAllowedFor.getClass()));
            }
        }
        if (!(keystorePassword = this.getMapValueAsString(currentPrincipalDataMap, USER_CONFIG_KEYSTORE_PASSWORD)).isEmpty()) {
            authorizableConfigBean.setKeyStorePassword(keystorePassword);
        }
    }

    private void setupAuthorizableKeys(AuthorizableConfigBean authorizableConfigBean, Map<String, Object> keys) throws InvalidAuthorizableException, IOException, GeneralSecurityException {
        HashMap<String, Key> parsedKeys = new HashMap<String, Key>();
        for (Map.Entry<String, Object> entry : keys.entrySet()) {
            if (!(entry.getValue() instanceof Map)) {
                throw new InvalidAuthorizableException("Field '" + entry.getKey() + "' must be a map but is a " + String.valueOf(entry.getValue().getClass()));
            }
            Map keyFields = (Map)entry.getValue();
            Key key = StringUtils.isNotBlank((CharSequence)((CharSequence)keyFields.get(USER_CONFIG_KEY_CERTIFICATE))) ? Key.createFromPrivateKeyAndCertificate(this.decryptionService, (String)keyFields.get(USER_CONFIG_KEY_PRIVATE), (String)keyFields.get(USER_CONFIG_KEY_PRIVATE_PASSWORD), (String)keyFields.get(USER_CONFIG_KEY_CERTIFICATE), this.privateKeyDecryptor) : Key.createFromKeyPair(this.decryptionService, (String)keyFields.get(USER_CONFIG_KEY_PRIVATE), (String)keyFields.get(USER_CONFIG_KEY_PRIVATE_PASSWORD), (String)keyFields.get(USER_CONFIG_KEY_PUBLIC), this.privateKeyDecryptor);
            parsedKeys.put(entry.getKey(), key);
        }
        authorizableConfigBean.setKeys(parsedKeys);
    }

    protected String getMapValueAsString(Map<String, ?> currentAceDefinition, String propertyName) {
        if (currentAceDefinition.get(propertyName) != null) {
            return currentAceDefinition.get(propertyName).toString();
        }
        return "";
    }

    private static String normalizePath(String path) {
        if (path.endsWith("/") && path.length() > 1) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }
}

