/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.Privilege;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;

public class AceWrapper {
    private final JackrabbitAccessControlEntry ace;
    private final String jcrPath;

    public AceWrapper(JackrabbitAccessControlEntry ace, String jcrPath) {
        this.ace = ace;
        this.jcrPath = jcrPath;
    }

    public String getJcrPath() {
        return this.jcrPath;
    }

    public JackrabbitAccessControlEntry getAce() {
        return this.ace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ace == null ? 0 : this.ace.hashCode());
        result = 31 * result + (this.jcrPath == null ? 0 : this.jcrPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AceWrapper other = (AceWrapper)obj;
        if (this.ace == null ? other.ace != null : !this.ace.equals(other.ace)) {
            return false;
        }
        return !(this.jcrPath == null ? other.jcrPath != null : !this.jcrPath.equals(other.jcrPath));
    }

    public String toString() {
        return "AceWrapper [ace=" + String.valueOf(this.ace) + ", jcrPath=" + this.jcrPath + "]";
    }

    public String getRestrictionAsString(String name) throws RepositoryException {
        Value val = this.ace.getRestriction(name);
        if (val != null) {
            return this.ace.getRestriction(name).getString();
        }
        return null;
    }

    public String getPrivilegesString() {
        Privilege[] privileges = this.ace.getPrivileges();
        Object privilegesString = "";
        for (Privilege privilege : privileges) {
            privilegesString = (String)privilegesString + privilege.getName() + ",";
        }
        privilegesString = StringUtils.chop((String)privilegesString);
        return privilegesString;
    }
}

