/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper;

import biz.netcentric.cq.tools.actool.configmodel.AceBean;
import biz.netcentric.cq.tools.actool.history.InstallationLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.config.VaultSettings;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.io.Importer;
import org.apache.jackrabbit.vault.fs.io.SubArchive;
import org.apache.jackrabbit.vault.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentHelper {
    public static final Logger LOG = LoggerFactory.getLogger(ContentHelper.class);

    private ContentHelper() {
    }

    public static boolean createInitialContent(Session session, InstallationLogger history, String path, Set<AceBean> aceBeanSetFromConfig) throws RepositoryException, PathNotFoundException, ItemExistsException, ConstraintViolationException, VersionException, InvalidSerializedDataException, LockException, AccessDeniedException {
        String initialContent = ContentHelper.findInitialContentInConfigsForPath(aceBeanSetFromConfig, history);
        if (StringUtils.isBlank((CharSequence)initialContent)) {
            return false;
        }
        try {
            String parentPath = Text.getRelativeParent((String)path, (int)1);
            if (!session.nodeExists(parentPath)) {
                history.incMissingParentPathsForInitialContent();
                history.addVerboseMessage(LOG, "Parent path " + parentPath + " missing for initial content at " + path);
                return false;
            }
            ContentHelper.importContent(session, path, initialContent);
            history.addMessage(LOG, "Created initial content for path " + path);
            return true;
        }
        catch (Exception e) {
            history.addError(LOG, "Failed creating initial content for path " + path + ": " + String.valueOf(e), e);
            return false;
        }
    }

    private static String findInitialContentInConfigsForPath(Set<AceBean> aceBeanSetFromConfig, InstallationLogger history) {
        String initialContent = null;
        for (AceBean aceBean : aceBeanSetFromConfig) {
            String currentInitialContent = aceBean.getInitialContent();
            if (!StringUtils.isNotBlank((CharSequence)currentInitialContent)) continue;
            if (initialContent == null) {
                initialContent = currentInitialContent;
                continue;
            }
            throw new IllegalStateException("Invalid Configuration: Path " + aceBean.getJcrPath() + " defines initial content at two locations");
        }
        return initialContent;
    }

    public static void importContent(Session session, String path, String contentXmlStr) throws RepositoryException {
        String parentPath = Text.getRelativeParent((String)path, (int)1);
        try {
            session.getNode(parentPath);
        }
        catch (PathNotFoundException e) {
            throw new PathNotFoundException("Parent path " + parentPath + " for creating content at " + path + " does not exist", (Throwable)e);
        }
        String rootElementStr = "<jcr:root ";
        if (!contentXmlStr.contains(rootElementStr)) {
            throw new IllegalStateException("Invalid initial content for path " + path + ": " + rootElementStr + " must be provided as root element in XML");
        }
        String contentXmlStrAdjusted = contentXmlStr;
        if (!contentXmlStrAdjusted.contains("xmlns:cq")) {
            contentXmlStrAdjusted = contentXmlStrAdjusted.replace(rootElementStr, rootElementStr + " xmlns:cq=\"http://www.day.com/jcr/cq/1.0\" ");
        }
        if (!contentXmlStrAdjusted.contains("xmlns:jcr")) {
            contentXmlStrAdjusted = contentXmlStrAdjusted.replace(rootElementStr, rootElementStr + " xmlns:jcr=\"http://www.jcp.org/jcr/1.0\" ");
        }
        if (!contentXmlStrAdjusted.contains("xmlns:sling")) {
            contentXmlStrAdjusted = contentXmlStrAdjusted.replace(rootElementStr, rootElementStr + " xmlns:sling=\"http://sling.apache.org/jcr/sling/1.0\" ");
        }
        LOG.debug("Importing content for path {}\n{}", (Object)path, (Object)contentXmlStrAdjusted);
        try {
            SingleContentFileArchive archive = new SingleContentFileArchive(path, contentXmlStrAdjusted);
            ImportOptions importOptions = new ImportOptions();
            importOptions.setAutoSaveThreshold(Integer.MAX_VALUE);
            importOptions.setStrict(false);
            importOptions.setListener(new ProgressTrackerListener(){

                public void onMessage(ProgressTrackerListener.Mode mode, String action, String pathForListener) {
                    LOG.debug("FileVault: " + action + " " + pathForListener);
                }

                public void onError(ProgressTrackerListener.Mode mode, String pathForListener, Exception e) {
                    throw new IllegalArgumentException("Invalid content fragment at path " + pathForListener + ": " + String.valueOf(e), e);
                }
            });
            Importer importer = new Importer(importOptions);
            Node importRoot = session.getNode("/");
            importer.run((Archive)archive, importRoot);
        }
        catch (IOException e) {
            throw new RepositoryException("I/O Error during import operation: " + String.valueOf(e), (Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new RepositoryException("ConfigurationException during import operation: " + String.valueOf((Object)e), (Throwable)e);
        }
        LOG.debug("Imported content for path {}\n{}", (Object)path, (Object)contentXmlStrAdjusted);
    }

    static class SingleContentFileArchive
    implements Archive {
        private final String filterPath;
        private final String xmlContent;
        private final Archive.Entry root;

        public SingleContentFileArchive(String path, String xmlContent) {
            this.filterPath = path;
            this.xmlContent = xmlContent;
            this.root = new SingleContentFileArchiveEntry("/jcr_root" + path + "/.content.xml");
        }

        public void open(boolean strict) throws IOException {
        }

        public void close() {
        }

        public InputStream openInputStream(Archive.Entry entry) throws IOException {
            if (".content.xml".equals(entry.getName())) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(this.xmlContent.getBytes(StandardCharsets.UTF_8));
                return inputStream;
            }
            return null;
        }

        public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
            if (".content.xml".equals(entry.getName())) {
                InputStream is = this.openInputStream(entry);
                VaultInputSource vaultInputSource = new VaultInputSource(is){

                    public long getContentLength() {
                        return xmlContent.length();
                    }

                    public long getLastModified() {
                        return 0L;
                    }
                };
                return vaultInputSource;
            }
            return null;
        }

        public Archive.Entry getRoot() throws IOException {
            return this.root;
        }

        public Archive.Entry getEntry(String path) throws IOException {
            String name;
            String[] segs = Text.explode((String)path, (int)47);
            Archive.Entry root = this.getRoot();
            String[] stringArray = segs;
            int n = stringArray.length;
            for (int i = 0; i < n && (root = root.getChild(name = stringArray[i])) != null; ++i) {
            }
            return root;
        }

        public Archive.Entry getJcrRoot() throws IOException {
            return this.getRoot().getChild("jcr_root");
        }

        public Archive getSubArchive(String rootPath, boolean asJcrRoot) throws IOException {
            Archive.Entry root = this.getEntry(rootPath);
            return root == null ? null : new SubArchive((Archive)this, root, asJcrRoot);
        }

        public MetaInf getMetaInf() {
            DefaultMetaInf defaultMetaInf = new DefaultMetaInf();
            DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
            PathFilterSet pathFilterSet = new PathFilterSet();
            pathFilterSet.setRoot(this.filterPath);
            filter.add(pathFilterSet);
            defaultMetaInf.setFilter((WorkspaceFilter)filter);
            Properties props = new Properties();
            defaultMetaInf.setProperties(props);
            VaultSettings settings = new VaultSettings();
            defaultMetaInf.setSettings(settings);
            return defaultMetaInf;
        }

        static class SingleContentFileArchiveEntry
        implements Archive.Entry {
            private Archive.Entry child;
            private String name;

            SingleContentFileArchiveEntry(String relPath) {
                String[] pathBits = relPath.split("/", 2);
                this.name = pathBits[0];
                this.child = pathBits.length == 2 ? new SingleContentFileArchiveEntry(pathBits[1]) : null;
            }

            public String getName() {
                return this.name;
            }

            public boolean isDirectory() {
                return this.child != null;
            }

            public Collection<? extends Archive.Entry> getChildren() {
                return this.child != null ? Arrays.asList(this.child) : null;
            }

            public Archive.Entry getChild(String name) {
                return name != null && name.equals(this.child.getName()) ? this.child : null;
            }
        }
    }
}

