/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper.runtime;

import javax.jcr.Node;
import javax.jcr.Session;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeHelper {
    public static final Logger LOG = LoggerFactory.getLogger(RuntimeHelper.class);
    private static final String INSTALLER_CORE_BUNDLE_SYMBOLIC_ID = "org.apache.sling.installer.core";

    public static boolean isCompositeNodeStore(Session session) {
        try {
            String pathToCheck = "/apps";
            Node appsNode = session.getNode(pathToCheck);
            boolean hasPermission = session.hasPermission("/", "set_property");
            if (!hasPermission) {
                LOG.info("AC Tool is running with a session (userID: " + session.getUserID() + ") that does not have permissions 'set_property' at " + pathToCheck);
            }
            boolean hasCapability = session.hasCapability("addNode", (Object)appsNode, new Object[]{"nt:folder"});
            boolean isCompositeNode = hasPermission && !hasCapability;
            return isCompositeNode;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not check if session is connected to a composite node store: " + String.valueOf(e), e);
        }
    }

    public static int getCurrentStartLevel() {
        return RuntimeHelper.getCurrentStartLevel(FrameworkUtil.getBundle(RuntimeHelper.class).getBundleContext());
    }

    public static int getCurrentStartLevel(BundleContext bundleContext) {
        return ((FrameworkStartLevel)bundleContext.getBundle(0L).adapt(FrameworkStartLevel.class)).getStartLevel();
    }

    public static boolean isCloudReadyInstance() {
        Bundle[] bundles;
        boolean isCloudReadyInstance = true;
        for (Bundle bundle : bundles = FrameworkUtil.getBundle(RuntimeHelper.class).getBundleContext().getBundles()) {
            if (!INSTALLER_CORE_BUNDLE_SYMBOLIC_ID.equals(bundle.getSymbolicName())) continue;
            isCloudReadyInstance = false;
            break;
        }
        return isCloudReadyInstance;
    }
}

