/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.installhook;

import biz.netcentric.cq.tools.actool.api.InstallationResult;
import biz.netcentric.cq.tools.actool.helper.runtime.RuntimeHelper;
import biz.netcentric.cq.tools.actool.installhook.AcToolInstallHookService;
import biz.netcentric.cq.tools.actool.installhook.OsgiAwareInstallHook;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.packaging.InstallContext;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public class AcToolInstallHook
extends OsgiAwareInstallHook {
    private static final Logger LOG = LoggerFactory.getLogger(AcToolInstallHook.class);
    private static final String PROPERTY_ACTOOL_INSTALL_AT_INSTALLED_PHASE = "actool.atInstalledPhase";
    private boolean alreadyRan = false;

    public void execute(InstallContext context) throws PackageException {
        LOG.debug("Executing install hook for phase {}.", (Object)context.getPhase());
        switch (context.getPhase()) {
            case PREPARE: {
                if (this.shouldInstallInPhaseInstalled((PackageProperties)context.getPackage())) break;
                this.install(context);
                break;
            }
            case INSTALLED: {
                if (!this.shouldInstallInPhaseInstalled((PackageProperties)context.getPackage())) break;
                this.install(context);
                break;
            }
        }
    }

    private boolean shouldInstallInPhaseInstalled(PackageProperties properties) {
        return Boolean.parseBoolean(properties.getProperty(PROPERTY_ACTOOL_INSTALL_AT_INSTALLED_PHASE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(InstallContext context) throws PackageException {
        ProgressTrackerListener listener = context.getOptions().getListener();
        if (this.alreadyRan) {
            this.log("Evading attempt to run the install hook twice due to a bug in CQ.", listener);
            return;
        }
        this.alreadyRan = true;
        if (RuntimeHelper.isCloudReadyInstance()) {
            this.log("InstallHook is skipped by default in cloud (use package property 'actool.forceInstallHookInCloud = true' to force run)", listener);
            return;
        }
        this.log("Installing ACLs through AcToolInstallHook in phase " + String.valueOf(context.getPhase()) + "...", listener);
        ServiceReference<AcToolInstallHookService> acToolInstallHookService = this.getServiceReference(AcToolInstallHookService.class);
        if (acToolInstallHookService == null) {
            throw new PackageException("Could not get AcToolInstallHookService from OSGI service registry. Make sure the ACTool is installed!");
        }
        AcToolInstallHookService acService = (AcToolInstallHookService)this.getBundleContext().getService(acToolInstallHookService);
        if (acService == null) {
            throw new PackageException("Could not instantiate AcToolInstallHookService. Make sure the ACTool is installed and check the log for errors");
        }
        try {
            InstallationResult result;
            try {
                result = acService.installYamlFilesFromPackage(context.getPackage(), context.getSession(), context.getOptions().getListener());
            }
            catch (Exception e) {
                LOG.error("Exception during execution of install hook: " + String.valueOf(e), (Throwable)e);
                this.log("Exception while installing configurations: " + String.valueOf(e), listener);
                throw new PackageException(e.getMessage(), (Throwable)e);
            }
            if (!result.isSuccess()) {
                throw new PackageException("AC Tool installation failed with " + result.getErrors().size() + " errors. Check log for detailed error message(s)!");
            }
            this.log("Installed ACLs successfully through AcToolInstallHook!", listener);
        }
        finally {
            this.getBundleContext().ungetService(acToolInstallHookService);
        }
    }
}

