/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.ui;

import java.io.PrintWriter;
import org.apache.commons.lang3.StringEscapeUtils;

class HtmlWriter {
    final PrintWriter pw;
    final boolean isTouchUi;

    HtmlWriter(PrintWriter pw, boolean isTouchUi) {
        this.pw = pw;
        this.isTouchUi = isTouchUi;
    }

    void openTable(String id) {
        this.pw.println("<table id='" + id + "' " + (this.isTouchUi ? " is='coral-table'" : " class='content' cellpadding='0' cellspacing='0' width='100%'") + ">");
    }

    void closeTable() {
        this.pw.println("</table>");
    }

    void tableHeader(String title, int colspan, boolean escape) {
        this.tr();
        this.pw.print("<th " + (this.isTouchUi ? "  is='coral-table-headercell'" : " class='content container'") + " colspan='" + colspan + "'>");
        this.pw.print(escape ? StringEscapeUtils.escapeHtml4((String)title) : title);
        this.pw.println("</th>");
        this.closeTr();
    }

    void print(String s) {
        this.pw.print(s);
    }

    void println(String s) {
        this.pw.println(s);
    }

    void newLine() {
        this.pw.println("<br/>");
    }

    void openTd() {
        this.openTd(0);
    }

    void openTd(int colspan) {
        this.pw.print("<td " + (this.isTouchUi ? "is='coral-table-cell'" : " class='content'") + (String)(colspan > 0 ? " colspan='" + colspan + "'" : "") + ">");
    }

    void closeTd() {
        this.pw.print("</td>");
    }

    void td(String label) {
        this.td(label, 1);
    }

    void td(String label, int colspan) {
        this.openTd(colspan);
        this.pw.print(StringEscapeUtils.escapeHtml4((String)label));
        this.closeTd();
    }

    void tr() {
        this.pw.println("<tr " + (this.isTouchUi ? " is='coral-table-row'" : " class='content'") + ">");
    }

    void closeTr() {
        this.pw.println("</tr>");
    }

    void tableHeader(String title, int colspan) {
        this.tableHeader(title, colspan, true);
    }
}

