/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.validators;

import biz.netcentric.cq.tools.actool.configmodel.AceBean;
import biz.netcentric.cq.tools.actool.helper.AcHelper;
import biz.netcentric.cq.tools.actool.helper.Constants;
import biz.netcentric.cq.tools.actool.validators.ConfigurationsValidator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class YamlConfigurationsValidator
implements ConfigurationsValidator {
    @Override
    public void validateDuplicateAuthorizables(Set<String> groupsFromAllConfig, Set<String> groupsFromCurrentConfig, String configPath) throws IllegalArgumentException {
        if (CollectionUtils.containsAny(groupsFromAllConfig, groupsFromCurrentConfig)) {
            Object errorMessage = "Already defined authorizable: ";
            for (String group : groupsFromCurrentConfig) {
                if (!groupsFromAllConfig.contains(group)) continue;
                errorMessage = (String)errorMessage + group + " found in configuration file: " + configPath + "!";
                errorMessage = (String)errorMessage + " This authorizable was already defined in another configuration file on the system!";
                break;
            }
            throw new IllegalArgumentException((String)errorMessage);
        }
    }

    @Override
    public void validateSectionIdentifiers(Set<String> sectionIdentifiers, String filePath) throws IllegalArgumentException {
        if (!Constants.VALID_CONFIG_SECTION_IDENTIFIERS.containsAll(sectionIdentifiers)) {
            for (String identifier : sectionIdentifiers) {
                if (Constants.VALID_CONFIG_SECTION_IDENTIFIERS.contains(identifier)) continue;
                throw new IllegalArgumentException("invalid section identifier: " + identifier + " in configuration file: " + filePath + "\nvalid configuration section identifiers are: " + String.valueOf(Constants.VALID_CONFIG_SECTION_IDENTIFIERS));
            }
        }
    }

    @Override
    public void validateInitialContentForNoDuplicates(Set<AceBean> aceBeansFromConfig) throws IllegalArgumentException {
        Map<String, Set<AceBean>> pathBasedAceMapFromConfig = AcHelper.getPathBasedAceMap(aceBeansFromConfig, AcHelper.ACE_ORDER_ACTOOL_BEST_PRACTICE);
        for (String path : pathBasedAceMapFromConfig.keySet()) {
            Set<AceBean> aceBeanSet = pathBasedAceMapFromConfig.get(path);
            String initialContent = null;
            for (AceBean aceBean : aceBeanSet) {
                if (!StringUtils.isNotBlank((CharSequence)aceBean.getInitialContent())) continue;
                if (initialContent == null) {
                    initialContent = aceBean.getInitialContent();
                    continue;
                }
                throw new IllegalArgumentException("Duplicate 'initialContent' for path " + path);
            }
        }
    }

    @Override
    public void validateKeepOrder(Set<AceBean> aceBeansFromAllConfigs, Set<AceBean> aceBeansFromCurrentConfig, String sourceFile) {
        LinkedHashSet<String> pathsWithKeepOrderSet = new LinkedHashSet<String>();
        for (AceBean aceBean : aceBeansFromAllConfigs) {
            if (!aceBean.isKeepOrder()) continue;
            pathsWithKeepOrderSet.add(aceBean.getJcrPath());
        }
        if (aceBeansFromCurrentConfig != null) {
            for (AceBean aceBean : aceBeansFromCurrentConfig) {
                if (!aceBean.isKeepOrder() || !pathsWithKeepOrderSet.contains(aceBean.getJcrPath())) continue;
                throw new IllegalArgumentException("If keepOrder=true is used, the ACE definitions for one particular path must only be defined in one source file (ACE for " + aceBean.getJcrPath() + " and group " + aceBean.getAuthorizableId() + " as defined in " + sourceFile + " was defined before) ");
            }
        }
    }
}

