/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.validators.impl;

import biz.netcentric.cq.tools.actool.aem.AcToolCqActions;
import biz.netcentric.cq.tools.actool.configmodel.AceBean;
import biz.netcentric.cq.tools.actool.configmodel.Restriction;
import biz.netcentric.cq.tools.actool.helper.AccessControlUtils;
import biz.netcentric.cq.tools.actool.validators.AceBeanValidator;
import biz.netcentric.cq.tools.actool.validators.Validators;
import biz.netcentric.cq.tools.actool.validators.exceptions.AcConfigBeanValidationException;
import biz.netcentric.cq.tools.actool.validators.exceptions.DoubledDefinedActionException;
import biz.netcentric.cq.tools.actool.validators.exceptions.DoubledDefinedJcrPrivilegeException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidActionException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidGroupNameException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidJcrPrivilegeException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidPathException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidPermissionException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidRepGlobException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidRestrictionsException;
import biz.netcentric.cq.tools.actool.validators.exceptions.NoActionOrPrivilegeDefinedException;
import biz.netcentric.cq.tools.actool.validators.exceptions.NoGroupDefinedException;
import biz.netcentric.cq.tools.actool.validators.exceptions.TooManyActionsException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AceBeanValidatorImpl
implements AceBeanValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AceBeanValidatorImpl.class);
    private long currentBeanCounter = 0L;
    private AceBean aceBean;
    private Set<String> authorizableIdsFromCurrentConfig;
    private String previousAuthorizableId;

    public AceBeanValidatorImpl(Set<String> authorizableIdsFromCurrentConfig) {
        this.authorizableIdsFromCurrentConfig = authorizableIdsFromCurrentConfig;
    }

    public AceBeanValidatorImpl() {
    }

    @Override
    public boolean validate(AceBean aceBean, AccessControlManager aclManager) throws AcConfigBeanValidationException {
        this.aceBean = aceBean;
        return this.validate(aclManager);
    }

    private boolean validate(AccessControlManager aclManager) throws AcConfigBeanValidationException {
        if (this.aceBean.isInitialContentOnlyConfig()) {
            return true;
        }
        this.maintainBeanCounter();
        this.validateAuthorizableId();
        this.validateAcePath();
        boolean isActionDefined = this.validateActions();
        boolean isPrivilegeDefined = this.validatePrivileges(aclManager);
        this.validatePermission(this.aceBean);
        boolean isActionOrPrivilegeDefined = isActionDefined || isPrivilegeDefined;
        boolean hasInitialContent = StringUtils.isNotBlank((CharSequence)this.aceBean.getInitialContent());
        if (!isActionOrPrivilegeDefined && !hasInitialContent) {
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, this.aceBean.getAuthorizableId()) + ", no actions or privileges defined! Installation aborted!";
            LOG.error(errorMessage);
            throw new NoActionOrPrivilegeDefinedException(errorMessage);
        }
        this.validateRestrictions(this.aceBean, aclManager);
        return true;
    }

    private void maintainBeanCounter() {
        this.currentBeanCounter = StringUtils.equals((CharSequence)this.aceBean.getAuthorizableId(), (CharSequence)this.previousAuthorizableId) ? ++this.currentBeanCounter : 1L;
        this.previousAuthorizableId = this.aceBean.getAuthorizableId();
    }

    private boolean validateRestrictions(AceBean tmpAceBean, AccessControlManager aclManager) throws InvalidRepGlobException, InvalidRestrictionsException {
        boolean valid = true;
        List<Restriction> restrictions = tmpAceBean.getRestrictions();
        if (restrictions.isEmpty()) {
            return true;
        }
        HashSet<String> restrictionNamesFromAceBean = new HashSet<String>();
        for (Restriction restriction : restrictions) {
            restrictionNamesFromAceBean.add(restriction.getName());
        }
        Set<String> allowedRestrictionNames = this.getSupportedRestrictions(aclManager);
        if (!allowedRestrictionNames.containsAll(restrictionNamesFromAceBean)) {
            restrictionNamesFromAceBean.removeAll(allowedRestrictionNames);
            valid = false;
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, tmpAceBean.getAuthorizableId()) + ",  this repository doesn't support following restriction(s): " + String.valueOf(restrictionNamesFromAceBean);
            throw new InvalidRestrictionsException(errorMessage);
        }
        return valid;
    }

    private Set<String> getSupportedRestrictions(AccessControlManager aclManager) throws InvalidRepGlobException {
        HashSet<String> allowedRestrictions = new HashSet();
        try {
            JackrabbitAccessControlList jacl = this.getJackrabbitAccessControlList(aclManager);
            allowedRestrictions = new HashSet<String>(Arrays.asList(jacl.getRestrictionNames()));
        }
        catch (RepositoryException e) {
            throw new InvalidRepGlobException("Could not get restriction names from ACL of path: " + this.aceBean.getJcrPath());
        }
        return allowedRestrictions;
    }

    private JackrabbitAccessControlList getJackrabbitAccessControlList(AccessControlManager aclManager) throws RepositoryException, AccessDeniedException {
        JackrabbitAccessControlList jacl = null;
        if (!this.aceBean.getJcrPath().contains("*")) {
            jacl = AccessControlUtils.getModifiableAcl(aclManager, this.aceBean.getJcrPath());
        }
        if (jacl == null) {
            jacl = AccessControlUtils.getModifiableAcl(aclManager, "/");
        }
        return jacl;
    }

    private boolean validatePermission(AceBean tmpAclBean) throws InvalidPermissionException {
        String permission = tmpAclBean.getPermission();
        if (StringUtils.isNotBlank((CharSequence)this.aceBean.getInitialContent()) && StringUtils.isBlank((CharSequence)permission)) {
            return true;
        }
        if (!Validators.isValidPermission(permission)) {
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, tmpAclBean.getAuthorizableId()) + ", invalid permission: '" + permission + "'";
            LOG.error(errorMessage);
            throw new InvalidPermissionException(errorMessage);
        }
        tmpAclBean.setPermission(permission);
        return true;
    }

    private boolean validateActions() throws InvalidActionException, TooManyActionsException, DoubledDefinedActionException {
        String principal = this.aceBean.getAuthorizableId();
        String[] actions = this.aceBean.getActions();
        if (actions == null || actions.length == 0) {
            return false;
        }
        if (actions.length > AcToolCqActions.CqActions.values().length) {
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, principal) + " too many actions defined!";
            LOG.error(errorMessage);
            throw new TooManyActionsException(errorMessage);
        }
        HashSet<String> actionsSet = new HashSet<String>();
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = StringUtils.strip((String)actions[i]);
            if (!Validators.isValidAction(actions[i])) {
                String errorMessage = this.getBeanDescription(this.currentBeanCounter, principal) + ", invalid action: " + actions[i];
                LOG.error(errorMessage);
                throw new InvalidActionException(errorMessage);
            }
            if (actionsSet.add(actions[i])) continue;
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, principal) + ", doubled defined action: " + actions[i];
            LOG.error(errorMessage);
            throw new DoubledDefinedActionException(errorMessage);
        }
        this.aceBean.setActions(actions);
        return true;
    }

    public boolean validatePrivileges(AccessControlManager aclManager) throws InvalidJcrPrivilegeException, DoubledDefinedJcrPrivilegeException {
        String currentEntryValue = this.aceBean.getPrivilegesString();
        if (!StringUtils.isNotBlank((CharSequence)currentEntryValue)) {
            return false;
        }
        String[] privileges = currentEntryValue.split(",");
        HashSet<String> privilegesSet = new HashSet<String>();
        for (int i = 0; i < privileges.length; ++i) {
            privileges[i] = StringUtils.strip((String)privileges[i]);
            if (!Validators.isValidJcrPrivilege(privileges[i], aclManager)) {
                String errorMessage = this.getBeanDescription(this.currentBeanCounter, this.aceBean.getAuthorizableId()) + ",  invalid jcr privilege: " + privileges[i];
                LOG.error(errorMessage);
                throw new InvalidJcrPrivilegeException(errorMessage);
            }
            if (privilegesSet.add(privileges[i])) continue;
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, this.aceBean.getAuthorizableId()) + ", doubled defined jcr privilege: " + privileges[i];
            LOG.error(errorMessage);
            throw new DoubledDefinedJcrPrivilegeException(errorMessage);
        }
        this.aceBean.setPrivilegesString(currentEntryValue);
        return true;
    }

    private boolean validateAcePath() throws InvalidPathException {
        boolean isPathDefined = false;
        String currentEntryValue = this.aceBean.getJcrPath();
        if (!Validators.isValidNodePath(currentEntryValue)) {
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, this.aceBean.getAuthorizableId()) + ", invalid path: " + currentEntryValue;
            LOG.error(errorMessage);
            throw new InvalidPathException(errorMessage);
        }
        this.aceBean.setJcrPath(currentEntryValue);
        isPathDefined = true;
        return isPathDefined;
    }

    private boolean validateAuthorizableId() throws NoGroupDefinedException, InvalidGroupNameException {
        boolean valid = true;
        String authorizableId = this.aceBean.getAuthorizableId();
        if (Validators.isValidAuthorizableId(authorizableId)) {
            if (!this.authorizableIdsFromCurrentConfig.contains(authorizableId)) {
                String message = this.getBeanDescription(this.currentBeanCounter, authorizableId) + " is not defined in group configuration";
                throw new NoGroupDefinedException(message);
            }
        } else {
            valid = false;
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, authorizableId) + authorizableId + ", invalid authorizable name: " + authorizableId;
            LOG.error(errorMessage);
            throw new InvalidGroupNameException(errorMessage);
        }
        this.aceBean.setAuthorizableId(authorizableId);
        return valid;
    }

    private String getBeanDescription(long beanCounter, String authorizableId) {
        return "Validation error while reading ACE definition nr." + beanCounter + " of authorizable " + authorizableId;
    }
}

