/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.ims;

import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.externalusermanagement.ExternalGroupManagement;
import biz.netcentric.cq.tools.actool.ims.request.ActionCommand;
import biz.netcentric.cq.tools.actool.ims.request.AddGroupMembers;
import biz.netcentric.cq.tools.actool.ims.request.AddGroupMembership;
import biz.netcentric.cq.tools.actool.ims.request.CreateGroupStep;
import biz.netcentric.cq.tools.actool.ims.request.Step;
import biz.netcentric.cq.tools.actool.ims.request.UserActionCommand;
import biz.netcentric.cq.tools.actool.ims.request.UserGroupActionCommand;
import biz.netcentric.cq.tools.actool.ims.response.AccessToken;
import biz.netcentric.cq.tools.actool.ims.response.ActionCommandResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Configuration.class)
public class IMSUserManagement
implements ExternalGroupManagement {
    public static final Logger LOG = LoggerFactory.getLogger(IMSUserManagement.class);
    private static final int MAX_NUM_COMMANDS_PER_REQUEST = 10;
    private static final int MAX_NUM_GROUPS_PER_ADD_STEP = 10;
    private final Configuration config;
    private final CloseableHttpClient client;

    @Activate
    public IMSUserManagement(Configuration config, @Reference HttpClientBuilderFactory httpClientBuilderFactory) {
        this.config = config;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(config.connectTimeout()).setConnectionRequestTimeout(config.socketTimeout()).setSocketTimeout(config.socketTimeout()).build();
        this.client = httpClientBuilderFactory.newBuilder().setDefaultRequestConfig(requestConfig).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new TooManyRequestsRetryStrategy(3, 5)).build();
    }

    @Deactivate
    public void deactivate() throws IOException {
        this.client.close();
    }

    private URI getUserManagementActionUrl() throws URISyntaxException {
        URI uri = new URI(this.config.umapiBaseUrl() + this.config.organizationId());
        if (this.config.isTestOnly()) {
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), "testOnly=true", uri.getFragment());
        }
        return uri;
    }

    @Override
    public String getLabel() {
        return "Adobe IMS";
    }

    @Override
    public void updateGroups(Collection<AuthorizableConfigBean> groupConfigs) throws IOException {
        LinkedList<ActionCommand> actionCommands = new LinkedList<ActionCommand>();
        for (AuthorizableConfigBean groupConfig : groupConfigs) {
            UserGroupActionCommand actionCommand = new UserGroupActionCommand(groupConfig.getAuthorizableId());
            CreateGroupStep createGroupStep = new CreateGroupStep();
            createGroupStep.description = groupConfig.getDescription();
            actionCommand.addStep(createGroupStep);
            if (this.config.productProfiles() != null && this.config.productProfiles().length > 0) {
                String[] addMembers = new AddGroupMembers();
                addMembers.productProfileIds = new HashSet<String>(Arrays.asList(this.config.productProfiles()));
                actionCommand.addStep((Step)addMembers);
            }
            actionCommands.add(actionCommand);
        }
        if (this.config.groupAdmins() != null && this.config.groupAdmins().length > 0) {
            AtomicInteger groupCounter = new AtomicInteger();
            Collection<List<String>> adminGroupNameBatches = groupConfigs.stream().map(AuthorizableConfigBean::getAuthorizableId).map(id -> "_admin_" + id).collect(Collectors.groupingBy(it -> groupCounter.getAndIncrement() / 10)).values();
            for (List list : adminGroupNameBatches) {
                for (String groupAdmin : this.config.groupAdmins()) {
                    UserActionCommand actionCommand = new UserActionCommand(groupAdmin);
                    AddGroupMembership addGroupMembership = new AddGroupMembership(list);
                    actionCommand.addStep(addGroupMembership);
                    actionCommands.add(actionCommand);
                }
            }
        }
        AtomicInteger counter = new AtomicInteger();
        Collection<List<ActionCommand>> actionCommandsBatches = actionCommands.stream().collect(Collectors.groupingBy(it -> counter.getAndIncrement() / 10)).values();
        String token = this.getOAuthServer2ServerToken();
        for (List<ActionCommand> actionCommandBatch : actionCommandsBatches) {
            ActionCommandResponse response = this.sendActionCommand(token, actionCommandBatch);
            if (!response.errors.isEmpty()) {
                throw new IOException("Errors updating groups: " + response.errors + " for request " + IMSUserManagement.getRequestInfo((HttpRequest)response.associatedRequest));
            }
            if (response.warnings.isEmpty()) continue;
            LOG.warn("Some warnings during updating groups with request {}", (Object)IMSUserManagement.getRequestInfo((HttpRequest)response.associatedRequest));
            response.warnings.stream().forEach(w -> LOG.warn("Warning updating a group: {}", w));
        }
    }

    static String getRequestInfo(HttpRequest request) throws IOException {
        if (request == null) {
            return "Unknown";
        }
        StringBuilder requestInfo = new StringBuilder();
        requestInfo.append(request);
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)bs);
            requestInfo.append("\nwith payload:\n").append(new String(bs.toByteArray()));
        }
        return requestInfo.toString();
    }

    private ActionCommandResponse sendActionCommand(String token, Collection<ActionCommand> actions) throws IOException {
        HttpPost httpPost;
        final ObjectMapper objectMapper = new ObjectMapper();
        try {
            httpPost = new HttpPost(this.getUserManagementActionUrl());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not create valid URI from configuration", e);
        }
        String jsonPayload = objectMapper.writeValueAsString(actions);
        httpPost.setEntity((HttpEntity)new StringEntity(jsonPayload, ContentType.create((String)"application/json")));
        httpPost.setHeader("Authorization", "Bearer " + token);
        httpPost.setHeader("X-Api-Key", this.config.clientId());
        ResponseHandler<ActionCommandResponse> rh = new ResponseHandler<ActionCommandResponse>(){

            public ActionCommandResponse handleResponse(HttpResponse response) throws IOException {
                StatusLine statusLine = response.getStatusLine();
                HttpEntity entity = response.getEntity();
                if (statusLine.getStatusCode() >= 300) {
                    throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase() + ", body:" + EntityUtils.toString((HttpEntity)entity) + ", for request " + IMSUserManagement.getRequestInfo((HttpRequest)httpPost));
                }
                if (entity == null) {
                    throw new ClientProtocolException("Response contains no content for request" + IMSUserManagement.getRequestInfo((HttpRequest)httpPost));
                }
                ActionCommandResponse actionCommandResponse = (ActionCommandResponse)objectMapper.readValue(entity.getContent(), ActionCommandResponse.class);
                actionCommandResponse.associatedRequest = httpPost;
                return actionCommandResponse;
            }
        };
        LOG.debug("Calling UMAPI via {}", (Object)httpPost);
        return (ActionCommandResponse)this.client.execute((HttpUriRequest)httpPost, (ResponseHandler)rh);
    }

    private String getOAuthServer2ServerToken() throws IOException {
        HttpPost httpPost = new HttpPost(this.config.imsTokenEndpointUrl());
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("client_id", this.config.clientId()));
        params.add(new BasicNameValuePair("client_secret", this.config.clientSecret()));
        params.add(new BasicNameValuePair("grant_type", "client_credentials"));
        params.add(new BasicNameValuePair("scope", String.join((CharSequence)",", this.config.scopes())));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Consts.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        ResponseHandler<AccessToken> rh = new ResponseHandler<AccessToken>(){

            public AccessToken handleResponse(HttpResponse response) throws IOException {
                StatusLine statusLine = response.getStatusLine();
                HttpEntity entity = response.getEntity();
                if (statusLine.getStatusCode() >= 300) {
                    throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase() + ", body:" + EntityUtils.toString((HttpEntity)entity));
                }
                if (entity == null) {
                    throw new ClientProtocolException("Response contains no content");
                }
                ObjectMapper objectMapper = new ObjectMapper();
                ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                Charset charset = contentType.getCharset();
                try (InputStreamReader reader = new InputStreamReader(entity.getContent(), charset);){
                    AccessToken accessToken = (AccessToken)objectMapper.readValue((Reader)reader, AccessToken.class);
                    return accessToken;
                }
            }
        };
        AccessToken token = (AccessToken)this.client.execute((HttpUriRequest)httpPost, (ResponseHandler)rh);
        return token.token;
    }

    static final class TooManyRequestsRetryStrategy
    implements ServiceUnavailableRetryStrategy {
        private static final double DEFAULT_MULTIPLIER = 1.5;
        private final int maxRetryCount;
        private final int defaultRetryDelayInSeconds;
        private long retryDelayInMilliseconds;
        private final Random random = new Random();

        public TooManyRequestsRetryStrategy(int maxRetryCount, int defaultRetryDelayInSeconds) {
            this.maxRetryCount = maxRetryCount;
            this.defaultRetryDelayInSeconds = defaultRetryDelayInSeconds;
            this.retryDelayInMilliseconds = (long)defaultRetryDelayInSeconds * 1000L;
        }

        public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
            boolean shouldRetry;
            this.retryDelayInMilliseconds = (long)this.defaultRetryDelayInSeconds * 1000L;
            boolean bl = shouldRetry = executionCount <= this.maxRetryCount && response.getStatusLine().getStatusCode() == 429;
            if (shouldRetry) {
                Header retryAfterHeader = response.getFirstHeader("Retry-After");
                if (retryAfterHeader != null) {
                    this.retryDelayInMilliseconds = (long)Integer.parseInt(retryAfterHeader.getValue()) * 1000L;
                    LOG.info("Received 429 status with Retry-After header {}", (Object)retryAfterHeader.getValue());
                }
                this.retryDelayInMilliseconds = (long)((double)this.retryDelayInMilliseconds * Math.pow(1.5, executionCount));
                long jitter = (long)this.random.nextInt(this.defaultRetryDelayInSeconds) * 1000L;
                this.retryDelayInMilliseconds += jitter;
                LOG.info("Schedule retry no {} of {} in {} milliseconds (with jitter of {} ms) due to 429 response", new Object[]{executionCount, this.maxRetryCount, this.retryDelayInMilliseconds, jitter});
            }
            return shouldRetry;
        }

        public long getRetryInterval() {
            return this.retryDelayInMilliseconds;
        }
    }

    @ObjectClassDefinition(name="AC Tool Adobe IMS User Management", description="Settings of the API for user management tasks (UMAPI) in the Adobe IMS")
    protected static @interface Configuration {
        @AttributeDefinition(name="UMAPI Base URL", description="UMAPI Endpoint Base URL (the part prior the organization id)")
        public String umapiBaseUrl() default "https://usermanagement.adobe.io/v2/usermanagement/action/";

        @AttributeDefinition(name="Organization ID", description="The unique identifier for an organization. This is a string of the form A495E53@AdobeOrg where the prefix before the @ is a hexadecimal number. You can find this value as part of the URL path for the organization in the Adobe Admin Console or in the Adobe Developer Console for your User Management integration.")
        public String organizationId();

        @AttributeDefinition(name="Test Only", description="If true, parameter syntactic and (limited) semantic checking is done, but the specified operations are not performed, so no user/group accounts or group memberships are created, changed, or deleted.")
        public boolean isTestOnly();

        @AttributeDefinition(name="IMS Token Endpoint URL", description="The URL from which to retrieve the access token.")
        public String imsTokenEndpointUrl() default "https://ims-na1.adobelogin.com/ims/token/v3";

        @AttributeDefinition(name="Client ID", description="The client ID exposed in the Adobe IO Console for the UMAPI integration used to authorize the session. Also used as \"X-Api-Key\" header value.")
        public String clientId();

        @AttributeDefinition(name="Client Secret", description="The client secret exposed in the Adobe IO Console for the UMAPI integration used to authorize the session.", type=AttributeType.PASSWORD)
        public String clientSecret();

        @AttributeDefinition(name="OAuth Scopes", description="Scopes for which the access token is requested.")
        public String[] scopes() default {"openid", "AdobeID", "user_management_sdk"};

        @AttributeDefinition(name="Connect Timeout", description="The maximum time to establish the connection with the remote host in milliseconds.")
        public int connectTimeout() default 2000;

        @AttributeDefinition(name="Socket Timeout", description="The time waiting for data \u2013 after establishing the connection; maximum time of inactivity between two data packets. Given in milliseconds.")
        public int socketTimeout() default 10000;

        @AttributeDefinition(name="AEM Product Profiles", description="The given product profile names are automatically added to each synchronized IMS group. The given product profile names must exist for an AEM product!")
        public String[] productProfiles() default {};

        @AttributeDefinition(name="Group Administrators", description="The given users are automatically added to each synchronized IMS group as administrator. The given user ids must already exist!")
        public String[] groupAdmins() default {};
    }
}

