/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.aceinstaller;

import biz.netcentric.cq.tools.actool.aceinstaller.AceBeanInstaller;
import biz.netcentric.cq.tools.actool.aceinstaller.BaseAceBeanInstaller;
import biz.netcentric.cq.tools.actool.aem.AcToolCqActions;
import biz.netcentric.cq.tools.actool.configmodel.AceBean;
import biz.netcentric.cq.tools.actool.configmodel.Restriction;
import biz.netcentric.cq.tools.actool.helper.AcHelper;
import biz.netcentric.cq.tools.actool.helper.AccessControlUtils;
import biz.netcentric.cq.tools.actool.history.InstallationLogger;
import biz.netcentric.cq.tools.actool.impl.SimpleNamePrincipal;
import java.security.Principal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AceBeanInstallerIncremental
extends BaseAceBeanInstaller
implements AceBeanInstaller {
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private SlingRepository slingRepository;
    private static final Logger LOG = LoggerFactory.getLogger(AceBeanInstallerIncremental.class);
    private Map<String, Set<AceBean>> actionsToPrivilegesMapping = new ConcurrentHashMap<String, Set<AceBean>>();

    @Override
    protected void installAcl(Set<AceBean> aceBeanSetFromConfig, String path, Set<String> principalsInConfiguration, Session session, InstallationLogger installLog) throws RepositoryException {
        boolean hadPendingChanges = session.hasPendingChanges();
        int countDeleted = 0;
        int countAdded = 0;
        int countNoChange = 0;
        int countOutsideConfig = 0;
        StringBuilder diffLog = new StringBuilder();
        aceBeanSetFromConfig = this.transformActionsIntoPrivileges(aceBeanSetFromConfig, session, installLog);
        aceBeanSetFromConfig = this.filterInitialContentOnlyNodes(aceBeanSetFromConfig);
        aceBeanSetFromConfig = this.filterDuplicates(aceBeanSetFromConfig, session);
        ArrayList<AceBean> configuredAceEntries = new ArrayList<AceBean>(aceBeanSetFromConfig);
        int currentPositionConfig = 0;
        boolean changeHasBeenFound = false;
        AccessControlManager acMgr = session.getAccessControlManager();
        JackrabbitAccessControlList acl = this.getAccessControlList(acMgr, path);
        for (AccessControlEntry ace : Arrays.asList(acl.getAccessControlEntries())) {
            AceBean configuredAceAtThisLocation;
            AceBean actualAceBean = AcHelper.getAceBean(ace, (AccessControlList)acl);
            String acePrincipalName = actualAceBean.getPrincipalName();
            String actualAceBeanCompareStr = this.toAceCompareString(actualAceBean, acMgr);
            if (!principalsInConfiguration.contains(acePrincipalName)) {
                ++countOutsideConfig;
                diffLog.append("    OUTSIDE (not in Config) " + actualAceBeanCompareStr + "\n");
                continue;
            }
            if (currentPositionConfig < configuredAceEntries.size()) {
                configuredAceAtThisLocation = (AceBean)configuredAceEntries.get(currentPositionConfig);
            } else {
                changeHasBeenFound = true;
                configuredAceAtThisLocation = null;
            }
            String configuredAceAtThisLocationCompareStr = this.toAceCompareString(configuredAceAtThisLocation, acMgr);
            boolean dumpEqualToConfig = StringUtils.equals((CharSequence)actualAceBeanCompareStr, (CharSequence)configuredAceAtThisLocationCompareStr);
            if (!changeHasBeenFound && !dumpEqualToConfig) {
                String configBeanStr = configuredAceAtThisLocationCompareStr;
                diffLog.append("<<< CHANGE (Repo Version)   " + actualAceBeanCompareStr + "\n>>> CHANGE (Config Version) " + configBeanStr + "\n");
            }
            if (changeHasBeenFound || !dumpEqualToConfig) {
                changeHasBeenFound = true;
                acl.removeAccessControlEntry(ace);
                ++countDeleted;
                diffLog.append("    DELETED (from Repo)     " + actualAceBeanCompareStr + "\n");
                continue;
            }
            ++currentPositionConfig;
            ++countNoChange;
            diffLog.append("    UNCHANGED               " + actualAceBeanCompareStr + "\n");
        }
        for (int i = currentPositionConfig; i < configuredAceEntries.size(); ++i) {
            AceBean aceBeanToAppend = (AceBean)configuredAceEntries.get(i);
            this.installPrivileges(aceBeanToAppend, (Principal)((Object)new SimpleNamePrincipal(aceBeanToAppend.getPrincipalName())), acl, session, acMgr);
            diffLog.append("    APPENDED (from Config)  " + this.toAceCompareString(aceBeanToAppend, acMgr) + "\n");
            ++countAdded;
        }
        if (countAdded > 0 || countDeleted > 0) {
            acMgr.setPolicy(StringUtils.isNotBlank((CharSequence)path) ? path : null, (AccessControlPolicy)acl);
            installLog.incCountAclsChanged();
            installLog.addVerboseMessage(LOG, "Update result at path " + path + ": O=" + countOutsideConfig + " N=" + countNoChange + " D=" + countDeleted + " A=" + countAdded + (String)(LOG.isDebugEnabled() ? "\nDIFF at " + path + "\n" + diffLog : ""));
        } else {
            installLog.incCountAclsNoChange();
        }
        if (!hadPendingChanges && session.hasPendingChanges()) {
            hadPendingChanges = true;
            installLog.addMessage(LOG, "Path " + path + " introduced pending changes to the session");
        }
    }

    private Set<AceBean> filterDuplicates(Set<AceBean> aceBeanSetFromConfig, Session session) throws UnsupportedRepositoryOperationException, RepositoryException {
        LinkedHashSet<AceBean> filteredAceBeans = new LinkedHashSet<AceBean>(aceBeanSetFromConfig);
        Iterator aceBeansIt = filteredAceBeans.iterator();
        HashSet<String> aceCompareKeysToAvoidDuplicates = new HashSet<String>();
        while (aceBeansIt.hasNext()) {
            String aceCompareKey = this.toAceCompareString((AceBean)aceBeansIt.next(), session.getAccessControlManager());
            if (aceCompareKeysToAvoidDuplicates.contains(aceCompareKey)) {
                aceBeansIt.remove();
                continue;
            }
            aceCompareKeysToAvoidDuplicates.add(aceCompareKey);
        }
        return filteredAceBeans;
    }

    private Set<AceBean> filterInitialContentOnlyNodes(Set<AceBean> aceBeanSetFromConfig) {
        LinkedHashSet<AceBean> aceBeanSetNoInitialContentOnlyNodes = new LinkedHashSet<AceBean>();
        for (AceBean aceBean : aceBeanSetFromConfig) {
            if (aceBean.isInitialContentOnlyConfig()) continue;
            aceBeanSetNoInitialContentOnlyNodes.add(aceBean);
        }
        return aceBeanSetNoInitialContentOnlyNodes;
    }

    protected JackrabbitAccessControlList getAccessControlList(AccessControlManager acMgr, String path) throws RepositoryException {
        JackrabbitAccessControlList acl = AccessControlUtils.getModifiableAcl(acMgr, path);
        return acl;
    }

    private Set<AceBean> transformActionsIntoPrivileges(Set<AceBean> aceBeanSetFromConfig, Session session, InstallationLogger installLog) throws RepositoryException {
        LinkedHashSet<AceBean> aceBeanSetWithPrivilegesOnly = new LinkedHashSet<AceBean>();
        for (AceBean origAceBean : aceBeanSetFromConfig) {
            if (origAceBean.getActionMap().isEmpty()) {
                aceBeanSetWithPrivilegesOnly.add(origAceBean);
                continue;
            }
            Set<AceBean> aceBeansForActionEntry = this.getPrincipalAceBeansForActionAceBeanCached(origAceBean, session, installLog);
            for (AceBean aceBeanResolvedFromAction : aceBeansForActionEntry) {
                aceBeanSetWithPrivilegesOnly.add(aceBeanResolvedFromAction);
            }
        }
        return aceBeanSetWithPrivilegesOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<AceBean> getPrincipalAceBeansForActionAceBeanCached(AceBean origAceBean, Session session, InstallationLogger installLog) throws RepositoryException {
        String cacheKey = (this.definesContent(origAceBean.getJcrPathForPolicyApi(), session) ? "definesContent" : "simple") + "-" + origAceBean.getPermission() + "-" + this.getRestrictionsComparable(origAceBean.getRestrictions()) + "-" + Arrays.toString(origAceBean.getActions());
        if (this.actionsToPrivilegesMapping.containsKey(cacheKey)) {
            installLog.incCountActionCacheHit();
            LOG.trace("Cache hit for key " + cacheKey);
            Set<AceBean> cachedAceBeansForActions = this.actionsToPrivilegesMapping.get(cacheKey);
            LinkedHashSet<AceBean> principalCorrectedAceBeansForActions = new LinkedHashSet<AceBean>();
            for (AceBean aceBean : cachedAceBeansForActions) {
                AceBean clone = aceBean.clone();
                clone.setPrincipalName(origAceBean.getPrincipalName());
                principalCorrectedAceBeansForActions.add(clone);
            }
            return principalCorrectedAceBeansForActions;
        }
        installLog.incCountActionCacheMiss();
        Set<AceBean> aceBeansForActionEntry = null;
        Session newSession = this.slingRepository.loginService(null, null);
        try {
            Session relevantSessionToUse;
            if (newSession.nodeExists(origAceBean.getJcrPath())) {
                relevantSessionToUse = newSession;
            } else {
                relevantSessionToUse = session;
                LOG.warn("Reusing main session for path {} since the node was only just created in that session via 'initialContent'", (Object)origAceBean.getJcrPath());
            }
            aceBeansForActionEntry = this.getPrincipalAceBeansForActionAceBean(origAceBean, relevantSessionToUse);
        }
        finally {
            newSession.logout();
        }
        LOG.debug("Adding to cache: {}={}", (Object)cacheKey, aceBeansForActionEntry);
        this.actionsToPrivilegesMapping.put(cacheKey, aceBeansForActionEntry);
        return aceBeansForActionEntry;
    }

    Set<AceBean> getPrincipalAceBeansForActionAceBean(AceBean origAceBean, Session session) throws RepositoryException {
        LinkedHashSet<AceBean> aceBeansForActionEntry = new LinkedHashSet<AceBean>();
        Principal testActionMapperPrincipal = this.getTestActionMapperPrincipal();
        this.applyCqActions(origAceBean, session, testActionMapperPrincipal);
        JackrabbitAccessControlList newAcl = this.getAccessControlList(session.getAccessControlManager(), origAceBean.getJcrPathForPolicyApi());
        boolean isFirst = true;
        for (AccessControlEntry newAce : newAcl.getAccessControlEntries()) {
            if (!newAce.getPrincipal().equals(testActionMapperPrincipal)) continue;
            String[] privilegesAceBeanForAction = AcHelper.getAceBean(newAce, (AccessControlList)newAcl);
            privilegesAceBeanForAction.setPrincipalName(origAceBean.getPrincipalName());
            if (isFirst) {
                if (origAceBean.containsRestriction("rep:glob") && privilegesAceBeanForAction.containsRestriction("rep:glob")) {
                    throw new IllegalArgumentException("When using actions that produce rep:glob restrictions (e.g. for page paths), rep:glob cannot be configured (origAceBean=" + origAceBean.getRestrictions() + ", privilegesAceBeanForAction=" + privilegesAceBeanForAction.getRestrictions() + "), check configuration for " + origAceBean);
                }
                privilegesAceBeanForAction.getRestrictions().addAll(origAceBean.getRestrictions());
            }
            aceBeansForActionEntry.add((AceBean)privilegesAceBeanForAction);
            newAcl.removeAccessControlEntry(newAce);
            isFirst = false;
        }
        AccessControlManager acMgr = session.getAccessControlManager();
        acMgr.setPolicy(origAceBean.getJcrPath(), (AccessControlPolicy)newAcl);
        AceBean firstMappedBean = (AceBean)aceBeansForActionEntry.iterator().next();
        LinkedHashSet<String> newPrivilegesFirstMappedBean = new LinkedHashSet<String>();
        if (firstMappedBean.getPrivileges() != null) {
            newPrivilegesFirstMappedBean.addAll(Arrays.asList(firstMappedBean.getPrivileges()));
        }
        Set<String> flatSetPrincipalsOfFirstMappedBean = this.flatSetResolvedAggregates(firstMappedBean.getPrivileges(), acMgr, true);
        if (origAceBean.getPrivileges() != null) {
            for (String origBeanPrivString : origAceBean.getPrivileges()) {
                if (flatSetPrincipalsOfFirstMappedBean.contains(origBeanPrivString)) continue;
                newPrivilegesFirstMappedBean.add(origBeanPrivString);
            }
        }
        firstMappedBean.setPrivilegesString(StringUtils.join(newPrivilegesFirstMappedBean, (String)","));
        if (LOG.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("CqActions at path " + origAceBean.getJcrPath() + " with authorizableId=" + origAceBean.getAuthorizableId() + "/" + testActionMapperPrincipal.getName() + " produced \n");
            for (AceBean aceBean : aceBeansForActionEntry) {
                buf.append("   " + this.toAceCompareString(aceBean, acMgr) + "\n");
            }
            LOG.debug(buf.toString());
        }
        return aceBeansForActionEntry;
    }

    Principal getTestActionMapperPrincipal() {
        String groupPrincipalId = "actool-tester-action-mapper";
        SimpleNamePrincipal principal = new SimpleNamePrincipal(groupPrincipalId);
        return principal;
    }

    void applyCqActions(AceBean origAceBean, Session session, Principal principal) throws RepositoryException {
        if (origAceBean.getActionMap().isEmpty()) {
            return;
        }
        AcToolCqActions cqActions = new AcToolCqActions(session);
        Collection<String> inheritedAllows = cqActions.getAllowedActions(origAceBean.getJcrPathForPolicyApi(), Collections.singleton(principal));
        cqActions.installActions(origAceBean.getJcrPath(), principal, origAceBean.getActionMap(), inheritedAllows);
    }

    private Set<String> flatSetResolvedAggregates(String[] privNames, AccessControlManager acMgr, boolean includeAggregates) throws RepositoryException {
        if (privNames == null) {
            return Collections.emptySet();
        }
        HashSet<String> privileges = new HashSet<String>();
        for (String name : privNames) {
            Privilege p = acMgr.privilegeFromName(name);
            if (!p.isAggregate() || includeAggregates) {
                privileges.add(p.getName());
            }
            if (!p.isAggregate()) continue;
            for (Privilege subPriv : p.getDeclaredAggregatePrivileges()) {
                Set<String> subPrivileges = this.flatSetResolvedAggregates(new String[]{subPriv.getName()}, acMgr, includeAggregates);
                privileges.addAll(subPrivileges);
            }
        }
        return privileges;
    }

    boolean definesContent(String pagePath, Session session) throws RepositoryException {
        if (pagePath == null || pagePath.equals("/")) {
            return false;
        }
        try {
            return AcToolCqActions.definesContent(session.getNode(pagePath));
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    private String toAceCompareString(AceBean aceBean, AccessControlManager acMgr) throws RepositoryException {
        if (aceBean == null) {
            return "null";
        }
        List<Restriction> restrictionsSorted = this.getRestrictionsComparable(aceBean.getRestrictions());
        String nonAggregatePrivsNormalized = this.privilegesToComparableSet(aceBean.getPrivileges(), acMgr);
        String aceCompareStr = aceBean.getPrincipalName() + " " + aceBean.getPermission() + " " + nonAggregatePrivsNormalized + Arrays.toString(restrictionsSorted.toArray());
        return aceCompareStr;
    }

    private List<Restriction> getRestrictionsComparable(List<Restriction> restrictions) {
        ArrayList<Restriction> restrictionsSorted = new ArrayList<Restriction>(restrictions);
        Collections.sort(restrictionsSorted, new Comparator<Restriction>(){

            @Override
            public int compare(Restriction r1, Restriction r2) {
                return Collator.getInstance().compare(r1.getName(), r2.getName());
            }
        });
        return restrictionsSorted;
    }

    String privilegesToComparableSet(String[] privileges, AccessControlManager acMgr) throws RepositoryException {
        return new TreeSet<String>(this.flatSetResolvedAggregates(privileges, acMgr, false)).toString();
    }
}

