/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.dumpservice.impl;

import biz.netcentric.cq.tools.actool.comparators.AcePathComparator;
import biz.netcentric.cq.tools.actool.comparators.AcePermissionComparator;
import biz.netcentric.cq.tools.actool.comparators.AuthorizableBeanIDComparator;
import biz.netcentric.cq.tools.actool.comparators.JcrCreatedComparator;
import biz.netcentric.cq.tools.actool.configmodel.AceBean;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.dumpservice.AcDumpElementYamlVisitor;
import biz.netcentric.cq.tools.actool.dumpservice.AceDumpData;
import biz.netcentric.cq.tools.actool.dumpservice.CompleteAcDump;
import biz.netcentric.cq.tools.actool.dumpservice.ConfigDumpService;
import biz.netcentric.cq.tools.actool.helper.AcHelper;
import biz.netcentric.cq.tools.actool.helper.AccessControlUtils;
import biz.netcentric.cq.tools.actool.helper.AceWrapper;
import biz.netcentric.cq.tools.actool.helper.AclBean;
import biz.netcentric.cq.tools.actool.helper.QueryHelper;
import biz.netcentric.cq.tools.actool.history.impl.HistoryUtils;
import biz.netcentric.cq.tools.actool.impl.SimpleNamePrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.version.VersionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Configuration.class)
public class DumpServiceImpl
implements ConfigDumpService {
    private static final Logger LOG = LoggerFactory.getLogger(DumpServiceImpl.class);
    private static final String DUMP_FILE_EXTENSION = ".yaml";
    private static final String DUMP_NODE_PREFIX = "dump_";
    public static final int PRINCIPAL_BASED_SORTING = 1;
    public static final int PATH_BASED_SORTING = 2;
    public static final int DENY_ALLOW_ACL_SORTING = 1;
    public static final int NO_ACL_SORTING = 2;
    protected static final int NR_OF_DUMPS_TO_SAVE_DEFAULT = 5;
    static final String DUMP_SERVICE_EXCLUDE_PATHS_PATH = "DumpService.queryExcludePaths";
    static final String DUMP_SERVICE_NR_OF_SAVED_DUMPS = "DumpService.nrOfSavedDumps";
    static final String DUMP_INCLUDE_USERS = "DumpService.includeUsers";
    private String[] queryExcludePaths;
    private int nrOfSavedDumps;
    private boolean includeUsersInDumps = false;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private SlingRepository repository;

    @Activate
    public void activate(Configuration configuration) throws Exception {
        this.queryExcludePaths = configuration.DumpService_queryExcludePaths();
        this.nrOfSavedDumps = configuration.DumpService_nrOfSavedDumps();
        this.includeUsersInDumps = configuration.DumpService_includeUsers();
    }

    @Override
    public boolean isIncludeUsers() {
        return this.includeUsersInDumps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCompletePathBasedDumpsAsString() {
        Session session = null;
        try {
            session = this.repository.loginService(null, null);
            String dump = this.getCompleteDump(AcHelper.PATH_BASED_ORDER, AcHelper.ACE_ORDER_NONE, session);
            this.persistDump(dump, session);
            String string = dump;
            return string;
        }
        catch (RepositoryException e) {
            LOG.error("Repository exception in DumpserviceImpl", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCompletePrincipalBasedDumpsAsString() {
        Session session = null;
        try {
            session = this.repository.loginService(null, null);
            String dump = this.getCompleteDump(AcHelper.PRINCIPAL_BASED_ORDER, AcHelper.ACE_ORDER_ACTOOL_BEST_PRACTICE, session);
            this.persistDump(dump, session);
            String string = dump;
            return string;
        }
        catch (RepositoryException e) {
            LOG.error("Repository exception in DumpserviceImpl", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private void persistDump(String dump, Session session) {
        try {
            Node rootNode = HistoryUtils.getAcHistoryRootNode(session);
            this.createTransientDumpNode(dump, rootNode);
            session.save();
        }
        catch (RepositoryException e) {
            LOG.error("RepositoryException: {}", (Throwable)e);
        }
    }

    private void createTransientDumpNode(String dump, Node rootNode) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException, ValueFormatException {
        NodeIterator nodeIt = rootNode.getNodes();
        TreeSet<Node> dumpNodes = new TreeSet<Node>(new JcrCreatedComparator());
        Node previousDumpNode = null;
        while (nodeIt.hasNext()) {
            Node currNode = nodeIt.nextNode();
            if (!currNode.getName().startsWith(DUMP_NODE_PREFIX)) continue;
            dumpNodes.add(currNode);
        }
        if (!dumpNodes.isEmpty()) {
            previousDumpNode = dumpNodes.first();
        }
        if (dumpNodes.size() > this.nrOfSavedDumps - 1) {
            Node oldestDumpNode = dumpNodes.last();
            oldestDumpNode.remove();
        }
        Node dumpNode = this.getNewDumpNode(dump, rootNode);
        if (previousDumpNode != null) {
            rootNode.orderBefore(dumpNode.getName(), previousDumpNode.getName());
        }
    }

    private Node getNewDumpNode(String dump, Node rootNode) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException, ValueFormatException {
        long timestamp = System.currentTimeMillis();
        Node dumpNode = rootNode.addNode(DUMP_NODE_PREFIX + timestamp + DUMP_FILE_EXTENSION, "nt:file");
        Node dumpJcrContenNodet = dumpNode.addNode("jcr:content", "nt:resource");
        dumpJcrContenNodet.setProperty("jcr:mimeType", "text/plain");
        dumpJcrContenNodet.setProperty("jcr:encoding", "utf-8");
        dumpJcrContenNodet.setProperty("jcr:data", dump);
        return dumpNode;
    }

    private String getCompleteDump(int keyOrder, int aclOrderInMap, Session session) {
        LOG.info("Starting to create dump for " + (keyOrder == AcHelper.PRINCIPAL_BASED_ORDER ? "PRINCIPAL_BASED_ORDER" : "PATH_BASED_ORDER"));
        try {
            AceDumpData aceDumpData = this.createAclDumpMap(keyOrder, AcHelper.ACE_ORDER_ACTOOL_BEST_PRACTICE, Arrays.asList(this.queryExcludePaths), session);
            Map<String, Set<AceBean>> aclDumpMap = aceDumpData.getAceDump();
            Set<AuthorizableConfigBean> groupBeans = this.getGroupBeans(session);
            Set<User> usersFromACEs = this.getUsersFromAces(keyOrder, session, aclDumpMap);
            Set<AuthorizableConfigBean> userBeans = this.getUserBeans(usersFromACEs);
            String configurationDumpAsString = this.getConfigurationDumpAsString(aceDumpData, groupBeans, userBeans, aclOrderInMap);
            return configurationDumpAsString;
        }
        catch (IllegalStateException e) {
            LOG.error("IllegalStateException in DumpServiceImpl: {}", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("IOException in AceServiceImpl: {}", (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.error("RepositoryException in AceServiceImpl: {}", (Throwable)e);
        }
        return null;
    }

    private Set<User> getUsersFromAces(int mapOrder, Session session, Map<String, Set<AceBean>> aclDumpMap) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        HashSet<User> usersFromACEs;
        block4: {
            UserManager um;
            block3: {
                usersFromACEs = new HashSet<User>();
                um = ((JackrabbitSession)session).getUserManager();
                if (mapOrder != 1) break block3;
                Set<Object> userIds = new HashSet();
                userIds = aclDumpMap.keySet();
                for (String string : userIds) {
                    Authorizable authorizable = um.getAuthorizable((Principal)((Object)new SimpleNamePrincipal(string)));
                    if (authorizable.isGroup()) continue;
                    User user = (User)authorizable;
                    usersFromACEs.add(user);
                }
                break block4;
            }
            if (mapOrder != 2) break block4;
            for (Map.Entry<String, Set<AceBean>> entry : aclDumpMap.entrySet()) {
                Set<AceBean> set = entry.getValue();
                for (AceBean aceBean : set) {
                    String principalId = aceBean.getPrincipalName();
                    Authorizable authorizable = um.getAuthorizable((Principal)((Object)new SimpleNamePrincipal(principalId)));
                    if (authorizable.isGroup()) continue;
                    User user = (User)authorizable;
                    usersFromACEs.add(user);
                }
            }
        }
        return usersFromACEs;
    }

    @Override
    public String getConfigurationDumpAsString(AceDumpData aceDumpData, Set<AuthorizableConfigBean> groupSet, Set<AuthorizableConfigBean> userSet, int mapOrder) throws IOException {
        StringBuilder sb = new StringBuilder(20000);
        String dumpComment = "Dump created: " + new Date();
        new CompleteAcDump(aceDumpData, groupSet, userSet, mapOrder, dumpComment, this).accept(new AcDumpElementYamlVisitor(mapOrder, sb));
        return sb.toString();
    }

    @Override
    public Set<AclBean> getACLDumpBeans(Session session) throws RepositoryException {
        List<String> excludeNodesList = Arrays.asList(this.queryExcludePaths);
        Set<String> resultPaths = QueryHelper.getRepPolicyNodePaths(session, excludeNodesList);
        LinkedHashSet<AclBean> accessControBeanSet = new LinkedHashSet<AclBean>();
        for (String path : resultPaths) {
            try {
                String contextPath = !"rep:repoPolicy".equals(Text.getName((String)path)) ? Text.getRelativeParent((String)path, (int)1) : null;
                JackrabbitAccessControlList jackrabbitAcl = AccessControlUtils.getAccessControlList(session, contextPath);
                AclBean aclBean = new AclBean(jackrabbitAcl, contextPath);
                accessControBeanSet.add(aclBean);
            }
            catch (AccessDeniedException e) {
                LOG.error("AccessDeniedException: {}", (Throwable)e);
            }
            catch (ItemNotFoundException e) {
                LOG.error("ItemNotFoundException: {}", (Throwable)e);
            }
            catch (RepositoryException e) {
                LOG.error("RepositoryException: {}", (Throwable)e);
            }
        }
        return accessControBeanSet;
    }

    public AceDumpData createAclDumpMap(int keyOrder, int aclOrdering, List<String> excludePaths, Session session) throws ValueFormatException, IllegalArgumentException, IllegalStateException, RepositoryException {
        return this.createAclDumpMap(keyOrder, aclOrdering, excludePaths, this.includeUsersInDumps, session);
    }

    @Override
    public AceDumpData createAclDumpMap(int keyOrder, int aclOrdering, List<String> excludePaths, boolean isIncludeUsers, Session session) throws RepositoryException {
        AceDumpData aceDumpData = new AceDumpData();
        UserManager um = ((JackrabbitSession)session).getUserManager();
        TreeMap<String, Set<AceBean>> aceMap = new TreeMap<String, Set<AceBean>>();
        TreeMap<String, Set<AceBean>> legacyAceMap = new TreeMap<String, Set<AceBean>>();
        Set<AclBean> aclBeanSet = this.getACLDumpBeans(session);
        for (AclBean aclBean : aclBeanSet) {
            if (aclBean.getAcl() == null) continue;
            boolean allowExistsInListEarlier = false;
            for (AccessControlEntry ace : aclBean.getAcl().getAccessControlEntries()) {
                if (!(ace instanceof JackrabbitAccessControlEntry)) {
                    throw new IllegalStateException("AC entry is not a JackrabbitAccessControlEntry: " + ace);
                }
                AceWrapper tmpBean = new AceWrapper((JackrabbitAccessControlEntry)ace, aclBean.getJcrPath());
                AceBean tmpAceBean = AcHelper.getAceBean(tmpBean);
                if (tmpAceBean.isAllow()) {
                    allowExistsInListEarlier = true;
                } else if (allowExistsInListEarlier && !tmpAceBean.isAllow()) {
                    tmpAceBean.setKeepOrder(true);
                }
                Authorizable authorizable = um.getAuthorizable((Principal)((Object)new SimpleNamePrincipal(tmpAceBean.getPrincipalName())));
                if (authorizable != null) {
                    tmpAceBean.setAuthorizableId(authorizable.getID());
                    if (!authorizable.isGroup() && !isIncludeUsers) continue;
                    this.addBeanToMap(keyOrder, aclOrdering, aceMap, tmpAceBean);
                    continue;
                }
                this.addBeanToMap(keyOrder, aclOrdering, legacyAceMap, tmpAceBean);
            }
        }
        aceDumpData.setAceDump(aceMap);
        return aceDumpData;
    }

    private void addBeanToMap(int keyOrder, int aclOrdering, Map<String, Set<AceBean>> aceMap, AceBean aceBean) {
        if (keyOrder == AcHelper.PRINCIPAL_BASED_ORDER) {
            String principalName = aceBean.getPrincipalName();
            if (!aceMap.containsKey(principalName)) {
                Set<AceBean> aceSet = this.getNewAceSet(aclOrdering);
                aceSet.add(aceBean);
                aceMap.put(principalName, aceSet);
            } else {
                aceMap.get(principalName).add(aceBean);
            }
        } else if (keyOrder == AcHelper.PATH_BASED_ORDER) {
            String jcrPath = aceBean.getJcrPath();
            if (jcrPath == null) {
                jcrPath = "";
            }
            if (!aceMap.containsKey(jcrPath)) {
                Set<AceBean> aceSet = this.getNewAceSet(aclOrdering);
                aceSet.add(aceBean);
                aceMap.put(jcrPath, aceSet);
            } else {
                aceMap.get(jcrPath).add(aceBean);
            }
        }
    }

    private String getIntermediatePath(String intermediatePath) {
        String result = StringUtils.substringBeforeLast((String)intermediatePath, (String)"/");
        return result;
    }

    public Set<AuthorizableConfigBean> getUserBeans(Set<User> usersFromACEs) throws RepositoryException, UnsupportedRepositoryOperationException {
        TreeSet<AuthorizableConfigBean> userBeans = new TreeSet<AuthorizableConfigBean>(new AuthorizableBeanIDComparator());
        if (!usersFromACEs.isEmpty()) {
            for (User user : usersFromACEs) {
                AuthorizableConfigBean newBean = new AuthorizableConfigBean();
                newBean.setAuthorizableId(user.getID());
                String userProfileName = StringUtils.trim((String)((String)StringUtils.defaultIfEmpty((CharSequence)AcHelper.valuesToString(user.getProperty("profile/givenName")), (CharSequence)"") + " " + (String)StringUtils.defaultIfEmpty((CharSequence)AcHelper.valuesToString(user.getProperty("profile/familyName")), (CharSequence)"")));
                if (StringUtils.isBlank((CharSequence)userProfileName)) {
                    userProfileName = user.getID();
                }
                newBean.setName(userProfileName);
                String intermediatePath = this.getIntermediatePath(user.getPath());
                newBean.setPath(intermediatePath);
                newBean.setIsGroup(false);
                newBean.setIsSystemUser(user.isSystemUser());
                new HashSet();
                this.addDeclaredMembers((Authorizable)user, newBean);
                userBeans.add(newBean);
            }
        }
        return userBeans;
    }

    @Override
    public Set<AuthorizableConfigBean> getGroupBeans(Session session) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        JackrabbitSession js = (JackrabbitSession)session;
        UserManager userManager = js.getUserManager();
        LinkedHashSet<AuthorizableConfigBean> groupBeans = new LinkedHashSet<AuthorizableConfigBean>();
        Iterator result = userManager.findAuthorizables(new Query(){

            public void build(QueryBuilder builder) {
                builder.setSortOrder("@rep:principalName", QueryBuilder.Direction.ASCENDING);
                builder.setSelector(Group.class);
            }
        });
        while (result.hasNext()) {
            Group group = (Group)result.next();
            if (group != null) {
                AuthorizableConfigBean bean = new AuthorizableConfigBean();
                bean.setAuthorizableId(group.getID());
                String groupName = (String)StringUtils.defaultIfEmpty((CharSequence)AcHelper.valuesToString(group.getProperty("profile/givenName")), (CharSequence)group.getID());
                bean.setName(groupName);
                if (group.hasProperty("rep:externalId")) {
                    bean.setExternalId(AcHelper.valuesToString(group.getProperty("rep:externalId")));
                }
                this.addDeclaredMembers((Authorizable)group, bean);
                bean.setIsGroup(group.isGroup());
                bean.setPath(this.getIntermediatePath(group.getPath()));
                groupBeans.add(bean);
                continue;
            }
            LOG.debug("group is null !");
        }
        return groupBeans;
    }

    private void addDeclaredMembers(Authorizable authorizable, AuthorizableConfigBean bean) throws RepositoryException {
        Iterator it = authorizable.declaredMemberOf();
        ArrayList<String> memberOfList = new ArrayList<String>();
        while (it.hasNext()) {
            String groupId = ((Group)it.next()).getID();
            if (StringUtils.equals((CharSequence)groupId, (CharSequence)"everyone")) continue;
            memberOfList.add(groupId);
        }
        bean.setIsMemberOf(memberOfList.toArray(new String[memberOfList.size()]));
    }

    private Set<AceBean> getNewAceSet(int aclOrdering) {
        AbstractSet aceSet = null;
        if (aclOrdering == AcHelper.ACE_ORDER_NONE) {
            aceSet = new LinkedHashSet<AceBean>();
        } else if (aclOrdering == AcHelper.ACE_ORDER_ACTOOL_BEST_PRACTICE) {
            aceSet = new TreeSet<AceBean>(new AcePermissionComparator());
        } else if (aclOrdering == AcHelper.ACE_ORDER_ALPHABETICAL) {
            aceSet = new TreeSet<AceBean>(new AcePathComparator());
        }
        return aceSet;
    }

    @ObjectClassDefinition(name="AC Tool Dump Service", description="Service that creates dumps of the current AC configurations (groups&ACEs)", id="biz.netcentric.cq.tools.actool.dumpservice.impl.DumpServiceImpl")
    protected static @interface Configuration {
        @AttributeDefinition(name="Number of dumps to save", description="Number of last dumps which get saved in the repository under /var/statistics/achistory")
        public int DumpService_nrOfSavedDumps() default 5;

        @AttributeDefinition(name="Include users in dumps", description="If selected, also users with their ACEs get added to dumps")
        public boolean DumpService_includeUsers() default false;

        @AttributeDefinition(name="AC query exclude paths", description="direct children of jcr:root which get excluded from all dumps (also from internal dumps)")
        public String[] DumpService_queryExcludePaths() default {"/home", "/jcr:system", "/tmp"};
    }
}

