/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.healthcheck;

import biz.netcentric.cq.tools.actool.history.AcHistoryService;
import biz.netcentric.cq.tools.actool.history.impl.HistoryUtils;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component
@Designate(ocd=Configuration.class)
public class LastRunSuccessHealthCheck
implements HealthCheck {
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private SlingRepository repository;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    AcHistoryService historyService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        if (!this.historyService.wasLastPersistHistoryCallSuccessful()) {
            resultLog.warn("Last execution of AC Tool could not persist its history. Check the log file for details.", new Object[0]);
            resultLog.info("Details about persisted history:", new Object[0]);
        }
        Session session = null;
        try {
            session = this.repository.loginService(null, null);
            Node statisticsRootNode = HistoryUtils.getAcHistoryRootNode(session);
            NodeIterator it = statisticsRootNode.getNodes();
            Node lastHistoryNode = null;
            while (it.hasNext()) {
                Node nextNode = it.nextNode();
                if (!nextNode.getName().startsWith("history")) continue;
                lastHistoryNode = nextNode;
                break;
            }
            if (lastHistoryNode != null) {
                boolean isSuccess = lastHistoryNode.getProperty("success").getBoolean();
                String installedFrom = lastHistoryNode.getProperty("installedFrom").getString();
                Long installationTime = lastHistoryNode.getProperty("timestamp").getLong();
                String msg = (isSuccess ? "Success" : "Failed") + " for " + installedFrom + " (" + new Date(installationTime) + ")";
                if (isSuccess) {
                    resultLog.info(msg, new Object[0]);
                } else {
                    resultLog.warn(msg, new Object[0]);
                }
            } else {
                resultLog.info("No AC Tool History entries exist", new Object[0]);
            }
        }
        catch (RepositoryException e) {
            Result result = new Result(Result.Status.HEALTH_CHECK_ERROR, "Error while retrieving last AC Tool runs", (Exception)((Object)e));
            return result;
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
        }
        return new Result((ResultLog)resultLog);
    }

    @ObjectClassDefinition(name="Sling Health Check: Last Run of AC Tool", description="Health Check Configuration", id="biz.netcentric.cq.tools.actool.healthcheck.LastRunSuccessHealthCheck")
    protected static @interface Configuration {
        @AttributeDefinition(name="Tags", description="Tags")
        public String[] hc_tags() default {"actool"};

        @AttributeDefinition(name="Cron expression", description="Cron expression for asynchronous execution (leave empty for synchronous execution)")
        public String hc_async_cronExpression();

        @AttributeDefinition(name="Name", description="Name")
        public String hc_name() default "Last Run of AC Tool";

        @AttributeDefinition(name="MBean", description="MBean name (leave empty for not using JMX)")
        public String hc_mbean_name() default "";
    }
}

