/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper;

import biz.netcentric.cq.tools.actool.helper.AclBean;
import biz.netcentric.cq.tools.actool.history.impl.PersistableInstallationLogger;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHelper {
    public static final Logger LOG = LoggerFactory.getLogger(QueryHelper.class);
    private static final String ROOT_REP_POLICY_NODE = "/rep:policy";
    private static final String ROOT_REPO_POLICY_NODE = "/rep:repoPolicy";
    private static final String HOME_REP_POLICY = "/home/rep:policy";
    private static final String EXPLAIN_QUERY_FOR_ACL_INDEX = "EXPLAIN MEASURE SELECT * FROM [rep:ACL] AS s WHERE ISDESCENDANTNODE([/])";
    private static final String KEY_COST_PER_EXECUTION = "perExecution";
    private static final double COST_THRESHOLD_FOR_QUERY_INDEX = 200.0;

    public static Set<String> getRepPolicyNodePaths(Session session, List<String> excludePaths) {
        NodeIterator nodeIt = null;
        try {
            nodeIt = session.getRootNode().getNodes();
        }
        catch (RepositoryException e) {
            LOG.error("Exception: {}", (Throwable)e);
        }
        TreeSet<String> rootChildrenPaths = new TreeSet<String>();
        while (nodeIt.hasNext()) {
            String currentPath = null;
            Node currentNode = nodeIt.nextNode();
            try {
                currentPath = currentNode.getPath();
            }
            catch (RepositoryException e) {
                LOG.error("Exception: {}", (Throwable)e);
            }
            try {
                if (currentNode.hasProperty("rep:AuthorizableFolder") || excludePaths.contains(currentPath)) continue;
                rootChildrenPaths.add(currentPath);
            }
            catch (RepositoryException e) {
                LOG.error("Exception: {}", (Throwable)e);
            }
        }
        HashSet<String> paths = new HashSet<String>();
        try {
            if (session.nodeExists(ROOT_REP_POLICY_NODE)) {
                paths.add(ROOT_REP_POLICY_NODE);
            }
            if (session.nodeExists(ROOT_REPO_POLICY_NODE)) {
                paths.add(ROOT_REPO_POLICY_NODE);
            }
            if (session.nodeExists(HOME_REP_POLICY)) {
                paths.add(HOME_REP_POLICY);
            }
            boolean indexForRepACLExists = false;
            try {
                indexForRepACLExists = QueryHelper.hasQueryIndexForACLs(session);
            }
            catch (Exception e) {
                LOG.warn("Could not detect if query index for rep:ACL nodes exists: {}", (Object)e.getMessage(), (Object)e);
            }
            LOG.debug("Index for repACL exists: {}", (Object)indexForRepACLExists);
            String queryForAClNodes = indexForRepACLExists ? "SELECT * FROM [rep:ACL] WHERE ISDESCENDANTNODE([%s])" : "SELECT ace.* FROM [rep:ACE] AS ace WHERE ace.[rep:principalName] IS NOT NULL AND ISDESCENDANTNODE(ace, [%s])";
            LOG.debug("Query to obtain all ACLs: {}", (Object)queryForAClNodes);
            for (String path : rootChildrenPaths) {
                if (StringUtils.equals((CharSequence)path, (CharSequence)ROOT_REP_POLICY_NODE) || StringUtils.equals((CharSequence)path, (CharSequence)ROOT_REPO_POLICY_NODE)) continue;
                String query = String.format(queryForAClNodes, path);
                long startTime1 = System.currentTimeMillis();
                Set<String> nodesResult = indexForRepACLExists ? QueryHelper.getNodePathsFromQuery(session, query, "JCR-SQL2") : QueryHelper.getDistinctParentNodePathsFromQuery(session, query, "JCR-SQL2");
                LOG.debug("Query to find ACLs under {} ran in {}ms (count ACLs: {})", new Object[]{path, System.currentTimeMillis() - startTime1, nodesResult.size()});
                paths.addAll(nodesResult);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not query repository for existing ACLs: " + e, e);
        }
        return paths;
    }

    public static boolean hasQueryIndexForACLs(Session session) throws RepositoryException, IOException {
        Query query = session.getWorkspace().getQueryManager().createQuery(EXPLAIN_QUERY_FOR_ACL_INDEX, "JCR-SQL2");
        QueryResult queryResult = query.execute();
        Row row = queryResult.getRows().nextRow();
        String plan = row.getValue("plan").getString();
        LOG.debug("Execution plan and cost for {}: {}", (Object)EXPLAIN_QUERY_FOR_ACL_INDEX, (Object)plan);
        String costJsonStr = StringUtils.substringAfter((String)plan, (String)"cost:");
        double cost = QueryHelper.getCostFromJsonStr(costJsonStr);
        LOG.debug("Cost for rep:ACL query is estimated with {}", (Object)cost);
        return cost <= 200.0;
    }

    static double getCostFromJsonStr(String jsonStr) throws JsonProcessingException, IOException {
        ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        JsonNode node = mapper.readTree(jsonStr);
        JsonNode sNode = node.get("s");
        if (sNode == null || sNode.isContainerNode() && sNode.get(KEY_COST_PER_EXECUTION) == null) {
            throw new IllegalArgumentException("Unexpected json structure for query cost: " + jsonStr);
        }
        double cost = sNode.isContainerNode() ? sNode.get(KEY_COST_PER_EXECUTION).asDouble(Double.MAX_VALUE) : sNode.asDouble(Double.MAX_VALUE);
        return cost;
    }

    public static Set<String> getNodePathsFromQuery(Session session, String xpathQuery) throws RepositoryException {
        return QueryHelper.getNodePathsFromQuery(session, xpathQuery, "xpath");
    }

    public static Set<String> getDistinctParentNodePathsFromQuery(Session session, String queryStatement, String queryLanguageType) throws InvalidQueryException, RepositoryException {
        Set<String> paths = QueryHelper.getNodePathsFromQuery(session, queryStatement, queryLanguageType);
        HashSet<String> parentPaths = new HashSet<String>();
        for (String path : paths) {
            parentPaths.add(Text.getRelativeParent((String)path, (int)1));
        }
        return parentPaths;
    }

    public static NodeIterator getNodesFromQuery(Session session, String queryStatement, String queryLanguageType) throws RepositoryException {
        Query query = session.getWorkspace().getQueryManager().createQuery(queryStatement, queryLanguageType);
        QueryResult queryResult = query.execute();
        return queryResult.getNodes();
    }

    public static Set<String> getNodePathsFromQuery(Session session, String queryStatement, String queryLanguageType) throws RepositoryException {
        HashSet<String> paths = new HashSet<String>();
        NodeIterator nit = QueryHelper.getNodesFromQuery(session, queryStatement, queryLanguageType);
        while (nit.hasNext()) {
            Node node = nit.nextNode();
            paths.add(node.getPath());
        }
        return paths;
    }

    public static Set<AclBean> getAuthorizablesAcls(Session session, Set<String> authorizableIds, Set<String> principalIdsToBeFilled) throws InvalidQueryException, RepositoryException {
        LOG.debug("Querying AclBeans for {} authorizables", (Object)authorizableIds.size());
        StopWatch sw = new StopWatch();
        sw.start();
        LinkedList<Node> nodes = new LinkedList<Node>();
        Iterator<String> authorizablesIdIterator = authorizableIds.iterator();
        while (authorizablesIdIterator.hasNext()) {
            StringBuilder queryStringBuilder = new StringBuilder();
            queryStringBuilder.append("SELECT ace.* FROM [rep:ACE] AS ace INNER JOIN [rep:Authorizable] AS authorizable ON ace.[rep:principalName] = authorizable.[rep:principalName] WHERE ");
            queryStringBuilder.append((CharSequence)QueryHelper.getAuthorizablesQueryStringBuilder(authorizablesIdIterator, 100));
            String query = queryStringBuilder.toString();
            NodeIterator nit = QueryHelper.getNodesFromQuery(session, query, "JCR-SQL2");
            LinkedList<Node> resultNodes = new LinkedList<Node>();
            while (nit.hasNext()) {
                resultNodes.add(nit.nextNode());
            }
            LOG.trace("Querying AclBeans with {} returned {} results", (Object)query, (Object)resultNodes.size());
            nodes.addAll(resultNodes);
        }
        Set<AclBean> resultBeans = QueryHelper.buildAclBeansFromNodes(session, nodes, principalIdsToBeFilled);
        sw.stop();
        LOG.debug("Found {} AclBeans in {}", (Object)resultBeans.size(), (Object)PersistableInstallationLogger.msHumanReadable(sw.getTime()));
        return resultBeans;
    }

    private static Set<AclBean> buildAclBeansFromNodes(Session session, Collection<Node> nodes, Set<String> principalIdsToBeFilled) throws UnsupportedRepositoryOperationException, RepositoryException, PathNotFoundException, AccessDeniedException, ItemNotFoundException {
        AccessControlManager aMgr = session.getAccessControlManager();
        TreeSet<AclBean> aclSet = new TreeSet<AclBean>();
        for (Node allowOrDenyNode : nodes) {
            String jcrPathAcl;
            String aclEffectiveOnPath;
            String principalId = allowOrDenyNode.getProperty("rep:principalName").getValue().getString();
            principalIdsToBeFilled.add(principalId);
            Node aclNode = allowOrDenyNode.getParent();
            if (!"rep:repoPolicy".equals(aclNode.getName())) {
                aclEffectiveOnPath = aclNode.getParent().getPath();
                jcrPathAcl = aclNode.getPath();
            } else {
                aclEffectiveOnPath = null;
                jcrPathAcl = ROOT_REPO_POLICY_NODE;
            }
            AccessControlList acl = QueryHelper.getValidAccessControlList(aMgr, aclEffectiveOnPath);
            if (acl == null) {
                LOG.warn("Path " + aclEffectiveOnPath + " unexpectedly does not have a ACL");
                continue;
            }
            AclBean aclBean = new AclBean();
            aclBean.setParentPath(aclEffectiveOnPath);
            aclBean.setAcl((JackrabbitAccessControlList)acl);
            aclBean.setJcrPath(jcrPathAcl);
            aclSet.add(aclBean);
        }
        return aclSet;
    }

    private static StringBuilder getAuthorizablesQueryStringBuilder(Iterator<String> authorizablesIdIterator, int authorizbalesLimitPerQuery) {
        int authorizableCounter = 0;
        StringBuilder querySb = new StringBuilder();
        if (!authorizablesIdIterator.hasNext()) {
            return querySb;
        }
        while (true) {
            querySb.append("authorizable.[rep:authorizableId] = '" + authorizablesIdIterator.next() + "'");
            if (++authorizableCounter >= authorizbalesLimitPerQuery || !authorizablesIdIterator.hasNext()) break;
            querySb.append(" or ");
        }
        return querySb;
    }

    private static AccessControlList getValidAccessControlList(AccessControlManager aMgr, String aclEffectiveOnPath) throws RepositoryException {
        AccessControlPolicy[] acps;
        for (AccessControlPolicy acp : acps = aMgr.getPolicies(aclEffectiveOnPath)) {
            if (!(acp instanceof AccessControlList)) continue;
            return (AccessControlList)acp;
        }
        return null;
    }
}

