/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.ui;

import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableTypeException;
import org.apache.jackrabbit.api.security.user.Group;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BoundPrincipals {
    private static final Logger log = LoggerFactory.getLogger(BoundPrincipals.class);
    private Set<Principal> boundPrincipals;

    BoundPrincipals(@NotNull JackrabbitSession session) throws RepositoryException {
        String userId = session.getUserID();
        this.boundPrincipals = (Set)session.getAttribute("oak.bound-principals");
        if (this.boundPrincipals == null) {
            this.boundPrincipals = new HashSet<Principal>();
            Authorizable authorizable = session.getUserManager().getAuthorizable(userId);
            if (authorizable == null) {
                throw new AuthorizableTypeException("Could not find authorizable for session's user ID " + userId);
            }
            this.boundPrincipals.add(authorizable.getPrincipal());
            Iterator groupIterator = authorizable.memberOf();
            while (groupIterator.hasNext()) {
                this.boundPrincipals.add(((Group)groupIterator.next()).getPrincipal());
            }
            log.debug("Bound principals calculated from user manager");
        } else {
            log.debug("Bound principals found in session attribute");
        }
        if (log.isDebugEnabled()) {
            log.debug("Bound principals for session associated with user id {}: {}", (Object)userId, (Object)this.boundPrincipals.stream().map(Principal::getName).collect(Collectors.joining(", ")));
        }
    }

    public boolean containsOneOf(@NotNull Collection<String> principalNames) {
        for (Principal principal : this.boundPrincipals) {
            if (!principalNames.contains(principal.getName())) continue;
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("None of the bound principals {} match any of the provided names: {}", (Object)this.boundPrincipals.stream().map(Principal::getName).collect(Collectors.joining(", ")), principalNames);
        }
        return false;
    }
}

