/*
 * Decompiled with CFR 0.152.
 */
package biz.neustar.loggly;

import biz.neustar.loggly.Loggly;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Formatter;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.codehaus.jackson.map.ObjectMapper;

public class LogglyHandler
extends Handler {
    private static final ObjectMapper OM = new ObjectMapper();
    private DefaultHttpClient httpClient;
    private ThreadPoolExecutor pool;
    private Queue<LogglySample> retryQueue;
    private boolean allowRetry = true;
    private String inputUrl;

    public LogglyHandler(String inputUrl) {
        this(inputUrl, 10, 5000);
    }

    public LogglyHandler(String inputUrl, int maxThreads, int backlog) {
        this.inputUrl = inputUrl;
        this.pool = new ThreadPoolExecutor(maxThreads, maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(backlog), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Loggly Thread");
                thread.setDaemon(true);
                return thread;
            }
        }, new ThreadPoolExecutor.DiscardOldestPolicy());
        this.pool.allowCoreThreadTimeOut(true);
        this.retryQueue = new LinkedBlockingQueue<LogglySample>(backlog);
        Thread retryThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (LogglyHandler.this.allowRetry) {
                    LogglySample sample = null;
                    while ((sample = (LogglySample)LogglyHandler.this.retryQueue.poll()) != null) {
                        if (sample.retryCount > 10) continue;
                        LogglyHandler.this.pool.submit(sample);
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        System.err.println("Retry sleep was interrupted, giving up on retry thread");
                        return;
                    }
                }
            }
        }, "Loggly Retry Thread");
        retryThread.setDaemon(true);
        retryThread.start();
        BasicHttpParams params = new BasicHttpParams();
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)maxThreads);
        ConnPerRouteBean connPerRoute = new ConnPerRouteBean(maxThreads);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)connPerRoute);
        params.setIntParameter("http.socket.timeout", 15000);
        params.setIntParameter("http.connection.timeout", 15000);
        SchemeRegistry registry = new SchemeRegistry();
        try {
            registry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not register SSL socket factor for Loggly", e);
        }
        ThreadSafeClientConnManager connManager = new ThreadSafeClientConnManager((HttpParams)params, registry);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)connManager, (HttpParams)params);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                LogglyHandler.this.close();
            }
        }));
    }

    @Override
    public void publish(LogRecord record) {
        Map<String, Object> map = Loggly.getMap();
        String level = "UNKN";
        if (record.getLevel().equals(Level.WARNING)) {
            level = "WARN";
        } else if (record.getLevel().equals(Level.SEVERE)) {
            level = "SEVR";
        } else if (record.getLevel().equals(Level.INFO)) {
            level = "INFO";
        } else if (record.getLevel().equals(Level.FINE)) {
            level = "FINE";
        } else if (record.getLevel().equals(Level.FINEST)) {
            level = "FNST";
        } else if (record.getLevel().equals(Level.FINER)) {
            level = "FINR";
        } else if (record.getLevel().equals(Level.CONFIG)) {
            level = "CONF";
        } else if (record.getLevel().equals(Level.OFF)) {
            level = "OFF ";
        } else if (record.getLevel().equals(Level.ALL)) {
            level = "ALL ";
        }
        if (record.getParameters() != null && record.getParameters().length > 0) {
            Formatter formatter = new Formatter();
            formatter.format(record.getMessage(), record.getParameters());
            map.put("message", formatter.toString());
        } else {
            map.put("message", record.getMessage());
        }
        map.put("thread", Thread.currentThread().getName());
        map.put("loggerName", record.getLoggerName());
        map.put("level", level);
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            record.getThrown().printStackTrace(new PrintWriter(sw));
            map.put("stackTrace", sw.toString());
        }
        this.pool.submit(new LogglySample(map));
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SecurityException {
        if (this.pool.isShutdown()) {
            return;
        }
        try {
            this.allowRetry = false;
            for (LogglySample sample : this.retryQueue) {
                this.pool.submit(sample);
            }
            this.retryQueue.clear();
            System.out.println("Shutting down Loggly handler - waiting 90 seconds for " + this.pool.getQueue().size() + " logs to finish");
            this.pool.shutdown();
            try {
                boolean result = this.pool.awaitTermination(90L, TimeUnit.SECONDS);
                if (!result) {
                    System.out.println("Not all Loggly messages sent out - still had " + this.pool.getQueue().size() + " left :(");
                    this.pool.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            this.httpClient.getConnectionManager().shutdown();
            System.out.println("Loggly handler shut down");
        }
    }

    private class LogglySample
    implements Runnable {
        private final Map<String, Object> map;
        private int retryCount = 0;
        private Exception exception;
        private int statusCode;

        public LogglySample(Map<String, Object> map) {
            this(map, 0);
        }

        private LogglySample(Map<String, Object> map, int retryCount) {
            this.map = map;
            this.retryCount = retryCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpEntity entity = null;
            try {
                HttpPost post = new HttpPost(LogglyHandler.this.inputUrl);
                StringWriter writer = new StringWriter();
                OM.writeValue((Writer)writer, this.map);
                post.setEntity((HttpEntity)new StringEntity(writer.toString()));
                post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                HttpResponse response = LogglyHandler.this.httpClient.execute((HttpUriRequest)post);
                entity = response.getEntity();
                this.statusCode = response.getStatusLine().getStatusCode();
                if (this.statusCode != 200 && LogglyHandler.this.allowRetry) {
                    ++this.retryCount;
                    LogglyHandler.this.retryQueue.offer(this);
                }
            }
            catch (Exception e) {
                if (LogglyHandler.this.allowRetry) {
                    this.exception = e;
                    ++this.retryCount;
                    LogglyHandler.this.retryQueue.offer(this);
                }
            }
            finally {
                if (entity != null) {
                    try {
                        entity.consumeContent();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

