/*
 * Decompiled with CFR 0.152.
 */
package biz.neustar.pagerduty;

import biz.neustar.pagerduty.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class IncidentsQuery {
    private String username;
    private Set<String> serviceIds = new HashSet<String>();
    private Set<String> statuses = new HashSet<String>();
    private Integer offset;
    private Integer limit;
    private SortByField sortByField;
    private SortByDirection sortByDirection;
    private String echo;
    private String[] fields;

    String queryParams() {
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        if (this.username != null) {
            nvps.add(new BasicNameValuePair("assigned_to_user", this.username));
        }
        for (String serviceId : this.serviceIds) {
            nvps.add(new BasicNameValuePair("service", serviceId));
        }
        for (String status : this.statuses) {
            nvps.add(new BasicNameValuePair("status", status));
        }
        if (this.offset != null) {
            nvps.add(new BasicNameValuePair("offset", String.valueOf(this.offset)));
        }
        if (this.limit != null) {
            nvps.add(new BasicNameValuePair("limit", String.valueOf(this.limit)));
        }
        if (this.sortByField != null) {
            if (this.sortByDirection == null) {
                this.sortByDirection = SortByDirection.ASC;
            }
            nvps.add(new BasicNameValuePair("sort_by", this.sortByField.name().toLowerCase() + ":" + this.sortByDirection.name().toLowerCase()));
        }
        if (this.echo != null) {
            nvps.add(new BasicNameValuePair("echo", this.echo));
        }
        if (this.fields != null) {
            nvps.add(new BasicNameValuePair("fields", StringUtils.join(this.fields)));
        }
        return URLEncodedUtils.format(nvps, (String)"UTF-8");
    }

    public IncidentsQuery withFields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public IncidentsQuery withEcho(String echo) {
        this.echo = echo;
        return this;
    }

    public IncidentsQuery withStatus(String ... statuses) {
        Collections.addAll(this.statuses, statuses);
        return this;
    }

    public IncidentsQuery assignedToUser(String username) {
        this.username = username;
        return this;
    }

    public IncidentsQuery withServices(String ... serviceIds) {
        Collections.addAll(this.serviceIds, serviceIds);
        return this;
    }

    public IncidentsQuery offset(int offset) {
        this.offset = offset;
        return this;
    }

    public IncidentsQuery limit(int limit) {
        this.limit = limit;
        return this;
    }

    public IncidentsQuery sortBy(SortByField field, SortByDirection direction) {
        this.sortByField = field;
        this.sortByDirection = direction;
        return this;
    }

    static enum SortByDirection {
        ASC,
        DESC;

    }

    static enum SortByField {
        INCIDENT_NUMBER,
        CREATED_ON,
        RESOLVED_ON;

    }
}

