/*
 * Decompiled with CFR 0.152.
 */
package biz.neustar.pagerduty;

import biz.neustar.pagerduty.IncidentsQuery;
import biz.neustar.pagerduty.InternalException;
import biz.neustar.pagerduty.InvalidEventException;
import biz.neustar.pagerduty.QueryException;
import biz.neustar.pagerduty.model.Event;
import biz.neustar.pagerduty.model.EventResponse;
import biz.neustar.pagerduty.model.Incident;
import biz.neustar.pagerduty.model.IncidentCount;
import biz.neustar.pagerduty.model.IncidentResults;
import biz.neustar.pagerduty.model.PagerDutyErrorWrapper;
import biz.neustar.pagerduty.util.LowerCaseWithUnderscoresStrategy;
import biz.neustar.pagerduty.util.PagerDutyHttpClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.codehaus.jackson.map.SerializationConfig;

public class PagerDutyClient {
    private static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private PagerDutyHttpClient client;
    private String baseUrl;
    private ObjectMapper mapper;

    @Inject
    public PagerDutyClient(@Named(value="pagerduty.subdomain") String subdomain, @Named(value="pagerduty.username") String username, @Named(value="pagerduty.password") String password) {
        this.client = new PagerDutyHttpClient(subdomain, username, password);
        this.baseUrl = "https://" + subdomain + ".pagerduty.com";
        this.mapper = PagerDutyClient.makeObjectMapper();
    }

    private static ObjectMapper makeObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new LowerCaseWithUnderscoresStrategy());
        return mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIncidentsCount(Date start, Date end, IncidentsQuery query) throws IOException, QueryException, InternalException {
        SimpleDateFormat sdf = new SimpleDateFormat(ISO8601_FORMAT);
        HttpGet get = new HttpGet(this.baseUrl + "/api/v1/incidents/count?since=" + sdf.format(start) + "&until=" + sdf.format(end) + "&" + query.queryParams());
        HttpResponse response = this.client.execute((HttpUriRequest)get);
        try {
            InputStream is = response.getEntity().getContent();
            int sc = response.getStatusLine().getStatusCode();
            if (sc >= 500) {
                throw new InternalException(response);
            }
            if (sc >= 400) {
                PagerDutyErrorWrapper wrapper = (PagerDutyErrorWrapper)this.mapper.readValue(is, PagerDutyErrorWrapper.class);
                throw new QueryException(wrapper.getError());
            }
            IncidentCount count = (IncidentCount)this.mapper.readValue(is, IncidentCount.class);
            int n = count.getTotal();
            return n;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Incident> getIncidents(Date start, Date end, IncidentsQuery query) throws IOException, QueryException, InternalException {
        SimpleDateFormat sdf = new SimpleDateFormat(ISO8601_FORMAT);
        HttpGet get = new HttpGet(this.baseUrl + "/api/v1/incidents?since=" + sdf.format(start) + "&until=" + sdf.format(end) + "&" + query.queryParams());
        HttpResponse response = this.client.execute((HttpUriRequest)get);
        try {
            InputStream is = response.getEntity().getContent();
            int sc = response.getStatusLine().getStatusCode();
            if (sc >= 500) {
                throw new InternalException(response);
            }
            if (sc >= 400) {
                PagerDutyErrorWrapper wrapper = (PagerDutyErrorWrapper)this.mapper.readValue(is, PagerDutyErrorWrapper.class);
                throw new QueryException(wrapper.getError());
            }
            IncidentResults results = (IncidentResults)this.mapper.readValue(is, IncidentResults.class);
            List<Incident> list = results.getIncidents();
            return list;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    public EventResponse trigger(String serviceKey, String description, String incidentKey, Object details) throws IOException, InternalException, InvalidEventException {
        return this.event("trigger", serviceKey, description, incidentKey, details);
    }

    public EventResponse acknowledge(String serviceKey, String description, String incidentKey, Object details) throws IOException, InternalException, InvalidEventException {
        return this.event("acknowledge", serviceKey, description, incidentKey, details);
    }

    public EventResponse resolve(String serviceKey, String description, String incidentKey, Object details) throws IOException, InternalException, InvalidEventException {
        return this.event("resolve", serviceKey, description, incidentKey, details);
    }

    private EventResponse event(String type, String serviceKey, String description, String incidentKey, Object details) throws IOException, InternalException, InvalidEventException {
        HttpPost post = new HttpPost("https://events.pagerduty.com/generic/2010-04-15/create_event.json");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.mapper.writeValue((OutputStream)baos, (Object)new Event(serviceKey, type, description, incidentKey, details));
        post.setEntity((HttpEntity)new ByteArrayEntity(baos.toByteArray()));
        HttpResponse response = this.client.execute((HttpUriRequest)post);
        try {
            int sc = response.getStatusLine().getStatusCode();
            InputStream is = response.getEntity().getContent();
            if (sc == 200) {
                EventResponse eventResponse = (EventResponse)this.mapper.readValue(is, EventResponse.class);
                return eventResponse;
            }
            if (sc == 400) {
                EventResponse resp = (EventResponse)this.mapper.readValue(is, EventResponse.class);
                throw new InvalidEventException(resp);
            }
            throw new InternalException(response);
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }
}

