/*
 * Decompiled with CFR 0.152.
 */
package biz.neustar.pagerduty.util;

import biz.neustar.pagerduty.util.Version;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;

@Singleton
public class PagerDutyHttpClient
extends DefaultHttpClient {
    private String subdomain;
    private AuthScope authScope;
    private UsernamePasswordCredentials creds;

    @Inject
    public PagerDutyHttpClient(@Named(value="pagerduty.subdomain") String subdomain, @Named(value="pagerduty.username") String username, @Named(value="pagerduty.password") String password) {
        this.subdomain = subdomain;
        this.authScope = new AuthScope(subdomain + ".pagerduty.com", 443);
        this.creds = new UsernamePasswordCredentials(username, password);
    }

    protected CredentialsProvider createCredentialsProvider() {
        CredentialsProvider provider = super.createCredentialsProvider();
        provider.setCredentials(this.authScope, (Credentials)this.creds);
        return provider;
    }

    protected HttpRequestExecutor createRequestExecutor() {
        return super.createRequestExecutor();
    }

    protected HttpContext createHttpContext() {
        HttpContext ctx = super.createHttpContext();
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        HttpHost host = new HttpHost(this.subdomain + ".pagerduty.com", 443, "https");
        authCache.put(host, (AuthScheme)basicAuth);
        ctx.setAttribute("http.auth.auth-cache", (Object)authCache);
        AuthState state = new AuthState();
        state.setAuthScheme((AuthScheme)basicAuth);
        state.setAuthScope(this.authScope);
        state.setCredentials((Credentials)this.creds);
        ctx.setAttribute("http.auth.target-scope", (Object)state);
        return ctx;
    }

    protected HttpParams createHttpParams() {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)("PagerDuty Client/" + Version.get()));
        return params;
    }

    protected ClientConnectionManager createClientConnectionManager() {
        SchemeRegistry registry = new SchemeRegistry();
        try {
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not register SSL socket factor for Loggly", e);
        }
        ThreadSafeClientConnManager connManager = new ThreadSafeClientConnManager(registry);
        int maxThreads = 4;
        connManager.setMaxTotal(maxThreads);
        connManager.setDefaultMaxPerRoute(maxThreads);
        return connManager;
    }
}

