/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf;

import biz.paluch.logging.gelf.intern.GelfMessage;
import java.util.HashMap;
import java.util.Map;

public class GelfMessageBuilder {
    protected String version = "1.0";
    protected String host;
    protected String shortMessage;
    protected String fullMessage;
    protected long javaTimestamp;
    protected String level;
    protected String facility = "logstash-gelf";
    protected int maximumMessageSize = 8192;
    protected Map<String, String> additionalFields = new HashMap<String, String>();
    protected Map<String, String> additionalFieldTypes = new HashMap<String, String>();

    protected GelfMessageBuilder() {
    }

    public static GelfMessageBuilder newInstance() {
        return new GelfMessageBuilder();
    }

    public GelfMessageBuilder withVersion(String version) {
        this.version = version;
        return this;
    }

    public GelfMessageBuilder withHost(String host) {
        this.host = host;
        return this;
    }

    public GelfMessageBuilder withShortMessage(String shortMessage) {
        this.shortMessage = shortMessage;
        return this;
    }

    public GelfMessageBuilder withFullMessage(String fullMessage) {
        this.fullMessage = fullMessage;
        return this;
    }

    public GelfMessageBuilder withLevel(String level) {
        this.level = level;
        return this;
    }

    public GelfMessageBuilder withFacility(String facility) {
        this.facility = facility;
        return this;
    }

    public GelfMessageBuilder withMaximumMessageSize(int maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
        return this;
    }

    public GelfMessageBuilder withJavaTimestamp(long javaTimestamp) {
        this.javaTimestamp = javaTimestamp;
        return this;
    }

    public GelfMessageBuilder withFields(Map<String, String> additionalFields) {
        this.additionalFields.putAll(additionalFields);
        return this;
    }

    public GelfMessageBuilder withField(String key, String value) {
        this.additionalFields.put(key, value);
        return this;
    }

    public GelfMessageBuilder withAdditionalFieldTypes(Map<String, String> additionalFieldTypes) {
        this.additionalFieldTypes.putAll(additionalFieldTypes);
        return this;
    }

    public GelfMessage build() {
        GelfMessage gelfMessage = new GelfMessage(this.shortMessage, this.fullMessage, this.javaTimestamp, this.level);
        gelfMessage.addFields(this.additionalFields);
        gelfMessage.setMaximumMessageSize(this.maximumMessageSize);
        gelfMessage.setVersion(this.version);
        gelfMessage.setHost(this.host);
        gelfMessage.setJavaTimestamp(this.javaTimestamp);
        gelfMessage.setFacility(this.facility);
        gelfMessage.setAdditionalFieldTypes(this.additionalFieldTypes);
        return gelfMessage;
    }
}

