/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern;

import biz.paluch.logging.RuntimeContainerProperties;
import biz.paluch.logging.gelf.GelfMessageBuilder;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.PoolHolder;
import biz.paluch.logging.gelf.intern.PoolingGelfMessage;

public class PoolingGelfMessageBuilder
extends GelfMessageBuilder {
    public static final String PROPERTY_USE_POOLING = "logstash-gelf.message.pooling";
    private static final String USE_POOLING_VAL = RuntimeContainerProperties.getProperty("logstash-gelf.message.pooling", "static");
    private static final boolean STATIC_POOLING = USE_POOLING_VAL.equalsIgnoreCase("static");
    private static final PoolHolder STATIC_POOL_HOLDER = STATIC_POOLING ? PoolHolder.threadLocal() : PoolHolder.noop();
    private final PoolHolder poolHolder;

    private PoolingGelfMessageBuilder(PoolHolder poolHolder) {
        this.poolHolder = poolHolder;
    }

    public static PoolingGelfMessageBuilder newInstance() {
        return new PoolingGelfMessageBuilder(STATIC_POOLING ? STATIC_POOL_HOLDER : PoolHolder.threadLocal());
    }

    public static boolean usePooling() {
        return STATIC_POOLING || USE_POOLING_VAL.equalsIgnoreCase("true");
    }

    public GelfMessageBuilder recycle() {
        this.version = "1.0";
        this.host = null;
        this.shortMessage = null;
        this.fullMessage = null;
        this.javaTimestamp = 0L;
        this.level = null;
        this.facility = "logstash-gelf";
        this.maximumMessageSize = 8192;
        this.additionalFields.clear();
        this.additionalFieldTypes.clear();
        return this;
    }

    @Override
    public GelfMessage build() {
        PoolingGelfMessage gelfMessage = new PoolingGelfMessage(this.shortMessage, this.fullMessage, this.javaTimestamp, this.level, this.poolHolder);
        gelfMessage.addFields(this.additionalFields);
        gelfMessage.setMaximumMessageSize(this.maximumMessageSize);
        gelfMessage.setVersion(this.version);
        gelfMessage.setHost(this.host);
        gelfMessage.setJavaTimestamp(this.javaTimestamp);
        gelfMessage.setFacility(this.facility);
        gelfMessage.setAdditionalFieldTypes(this.additionalFieldTypes);
        return gelfMessage;
    }
}

