/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class KafkaGelfSender
implements GelfSender {
    private final KafkaProducer<byte[], byte[]> kafkaProducer;
    private final String topicName;
    private final ErrorReporter errorReporter;

    public KafkaGelfSender(KafkaProducer<byte[], byte[]> kafkaProducer, String topicName, ErrorReporter errorReporter) {
        this.kafkaProducer = kafkaProducer;
        this.topicName = topicName;
        this.errorReporter = errorReporter;
    }

    @Override
    public boolean sendMessage(GelfMessage message) {
        boolean hasOffset;
        ProducerRecord record = new ProducerRecord(this.topicName, (Object)message.toJson().getBytes());
        try {
            Future metadata = this.kafkaProducer.send(record);
            hasOffset = ((RecordMetadata)metadata.get(30L, TimeUnit.SECONDS)).hasOffset();
        }
        catch (Exception e) {
            this.errorReporter.reportError("Error sending log to kafka", e);
            return false;
        }
        return hasOffset;
    }

    @Override
    public void close() {
        this.kafkaProducer.close();
    }
}

