/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.wildfly;

import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MdcGelfMessageAssembler;
import biz.paluch.logging.gelf.intern.ConfigurationSupport;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.jboss7.JBoss7JulLogEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtLogRecord;

public class WildFlyJsonFormatter
extends ExtFormatter {
    public static final String MULTI_VALUE_DELIMITTER = ",";
    private MdcGelfMessageAssembler gelfMessageAssembler = new MdcGelfMessageAssembler();
    private String lineBreak = "\n";
    private boolean wasSetFieldsCalled = false;
    public static final Set<LogMessageField.NamedLogField> SUPPORTED_FIELDS;

    public String format(ExtLogRecord extLogRecord) {
        if (!this.wasSetFieldsCalled) {
            this.addFields(SUPPORTED_FIELDS);
        }
        GelfMessage gelfMessage = this.gelfMessageAssembler.createGelfMessage(new JBoss7JulLogEvent(extLogRecord));
        return gelfMessage.toJson("") + this.getLineBreak();
    }

    public void setFields(String fieldSpec) {
        String[] properties = fieldSpec.split(MULTI_VALUE_DELIMITTER);
        ArrayList<LogMessageField.NamedLogField> fields = new ArrayList<LogMessageField.NamedLogField>();
        for (String field : properties) {
            LogMessageField.NamedLogField namedLogField = LogMessageField.NamedLogField.byName(field.trim());
            if (namedLogField == null) {
                throw new IllegalArgumentException("Cannot resolve field name '" + field + "' to a field. Supported field names are: " + SUPPORTED_FIELDS);
            }
            if (!SUPPORTED_FIELDS.contains((Object)namedLogField)) {
                throw new IllegalArgumentException("Field '" + field + "' is not supported. Supported field names are: " + SUPPORTED_FIELDS);
            }
            fields.add(namedLogField);
        }
        this.addFields(fields);
    }

    private void addFields(Collection<LogMessageField.NamedLogField> fields) {
        this.gelfMessageAssembler.addFields(LogMessageField.getDefaultMapping(fields.toArray(new LogMessageField.NamedLogField[fields.size()])));
        this.wasSetFieldsCalled = true;
    }

    public void setAdditionalFields(String spec) {
        ConfigurationSupport.setAdditionalFields(spec, this.gelfMessageAssembler);
    }

    public void setAdditionalFieldTypes(String spec) {
        ConfigurationSupport.setAdditionalFieldTypes(spec, this.gelfMessageAssembler);
    }

    public void setMdcFields(String spec) {
        ConfigurationSupport.setMdcFields(spec, this.gelfMessageAssembler);
    }

    public void setDynamicMdcFields(String spec) {
        ConfigurationSupport.setDynamicMdcFields(spec, this.gelfMessageAssembler);
    }

    public boolean isIncludeLocation() {
        return this.gelfMessageAssembler.isIncludeLocation();
    }

    public void setIncludeLocation(boolean includeLocation) {
        this.gelfMessageAssembler.setIncludeLocation(includeLocation);
    }

    public boolean isMdcProfiling() {
        return this.gelfMessageAssembler.isMdcProfiling();
    }

    public void setMdcProfiling(boolean mdcProfiling) {
        this.gelfMessageAssembler.setMdcProfiling(mdcProfiling);
    }

    public boolean isIncludeFullMdc() {
        return this.gelfMessageAssembler.isIncludeFullMdc();
    }

    public void setIncludeFullMdc(boolean includeFullMdc) {
        this.gelfMessageAssembler.setIncludeFullMdc(includeFullMdc);
    }

    public String getOriginHost() {
        return this.gelfMessageAssembler.getOriginHost();
    }

    public void setOriginHost(String originHost) {
        this.gelfMessageAssembler.setOriginHost(originHost);
    }

    public String getFacility() {
        return this.gelfMessageAssembler.getFacility();
    }

    public void setFacility(String facility) {
        this.gelfMessageAssembler.setFacility(facility);
    }

    public String getExtractStackTrace() {
        return this.gelfMessageAssembler.getExtractStackTrace();
    }

    public void setExtractStackTrace(String extractStacktrace) {
        this.gelfMessageAssembler.setExtractStackTrace(extractStacktrace);
    }

    public boolean isFilterStackTrace() {
        return this.gelfMessageAssembler.isFilterStackTrace();
    }

    public void setFilterStackTrace(boolean filterStackTrace) {
        this.gelfMessageAssembler.setFilterStackTrace(filterStackTrace);
    }

    public String getTimestampPattern() {
        return this.gelfMessageAssembler.getTimestampPattern();
    }

    public void setTimestampPattern(String timestampPattern) {
        this.gelfMessageAssembler.setTimestampPattern(timestampPattern);
    }

    public String getVersion() {
        return this.gelfMessageAssembler.getVersion();
    }

    public void setVersion(String version) {
        this.gelfMessageAssembler.setVersion(version);
    }

    public String getLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(String lineBreak) {
        this.lineBreak = lineBreak;
    }

    public boolean isIncludeLogMessageParameters() {
        return this.gelfMessageAssembler.isIncludeLogMessageParameters();
    }

    public void setIncludeLogMessageParameters(boolean includeLogMessageParameters) {
        this.gelfMessageAssembler.setIncludeLogMessageParameters(includeLogMessageParameters);
    }

    static {
        LinkedHashSet<LogMessageField.NamedLogField> supportedFields = new LinkedHashSet<LogMessageField.NamedLogField>();
        supportedFields.add(LogMessageField.NamedLogField.Time);
        supportedFields.add(LogMessageField.NamedLogField.Severity);
        supportedFields.add(LogMessageField.NamedLogField.ThreadName);
        supportedFields.add(LogMessageField.NamedLogField.SourceClassName);
        supportedFields.add(LogMessageField.NamedLogField.SourceMethodName);
        supportedFields.add(LogMessageField.NamedLogField.SourceSimpleClassName);
        supportedFields.add(LogMessageField.NamedLogField.LoggerName);
        supportedFields.add(LogMessageField.NamedLogField.NDC);
        supportedFields.add(LogMessageField.NamedLogField.Server);
        SUPPORTED_FIELDS = Collections.unmodifiableSet(supportedFields);
    }
}

