/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern;

class ValueDiscovery {
    ValueDiscovery() {
    }

    static Result discover(String value) {
        long len = value.length();
        if (len == 0L || len > 32L) {
            return Result.STRING;
        }
        int points = -1;
        char firstChar = value.charAt(0);
        if (firstChar < '0' || firstChar > '9') {
            if (firstChar == 'N' && value.contains("NaN")) {
                return Result.DOUBLE;
            }
            if (firstChar == 'I' && value.contains("Infinity")) {
                return Result.DOUBLE;
            }
            if (firstChar != '-' && firstChar != '+') {
                return Result.STRING;
            }
        }
        Result discoveryResult = Result.LONG;
        int i = 1;
        while ((long)i < len) {
            char c = value.charAt(i);
            if (c < '0' || c > '9') {
                switch (c) {
                    case '.': {
                        if (points != -1) {
                            return Result.STRING;
                        }
                        points = i;
                        discoveryResult = Result.DOUBLE;
                        break;
                    }
                    case '+': 
                    case '-': {
                        discoveryResult = Result.DOUBLE;
                        break;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'P': 
                    case 'X': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'p': 
                    case 'x': {
                        discoveryResult = Result.DOUBLE;
                        break;
                    }
                    default: {
                        return Result.STRING;
                    }
                }
            }
            ++i;
        }
        return discoveryResult;
    }

    static enum Result {
        STRING,
        LONG,
        DOUBLE;

    }
}

