/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class RuntimeContainer {
    public static final String HOSTNAME;
    public static final String FQDN_HOSTNAME;
    public static final String ADDRESS;
    public static final long FIRST_ACCESS;
    private static final Logger LOGGER;

    private RuntimeContainer() {
    }

    private static String getHostname(InetAddress inetAddress, boolean fqdn) throws IOException {
        String hostname = inetAddress.getHostName();
        if (hostname.indexOf(46) != -1 && !fqdn) {
            hostname = hostname.substring(0, hostname.indexOf(46));
        }
        return hostname;
    }

    private static InetAddress getInetAddressWithHostname() throws SocketException {
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> ias = ni.getInetAddresses();
            while (ias.hasMoreElements()) {
                InetAddress inetAddress = ias.nextElement();
                if (inetAddress.isLoopbackAddress() || inetAddress.getHostAddress().equals(inetAddress.getCanonicalHostName())) continue;
                return inetAddress;
            }
        }
        return null;
    }

    static {
        LOGGER = Logger.getLogger(RuntimeContainer.class);
        FIRST_ACCESS = System.currentTimeMillis();
        String myHostName = "unknown";
        String myFQDNHostName = "unknown";
        String myAddress = "";
        try {
            InetAddress inetAddress = RuntimeContainer.getInetAddressWithHostname();
            if (inetAddress == null) {
                inetAddress = InetAddress.getLocalHost();
            }
            myHostName = RuntimeContainer.getHostname(inetAddress, false);
            myFQDNHostName = RuntimeContainer.getHostname(inetAddress, true);
            myAddress = inetAddress.getHostAddress();
        }
        catch (IOException e) {
            LOGGER.info((Object)e.getMessage(), (Throwable)e);
        }
        FQDN_HOSTNAME = myFQDNHostName;
        HOSTNAME = myHostName;
        ADDRESS = myAddress;
    }
}

