/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf;

import biz.paluch.logging.gelf.LogEvent;
import biz.paluch.logging.gelf.intern.GelfMessage;
import java.util.Date;

public class GelfUtil {
    public static final String MDC_REQUEST_START_MS = "profiling.requestStart.millis";
    public static final String MDC_REQUEST_END = "profiling.requestEnd";
    public static final String MDC_REQUEST_DURATION = "profiling.requestDuration";

    private GelfUtil() {
    }

    public static void addMdcProfiling(LogEvent logEvent, GelfMessage gelfMessage) {
        String requestStartMsString;
        String requestStartMs = logEvent.getMdc(MDC_REQUEST_START_MS);
        long timestamp = -1L;
        if (requestStartMs instanceof Long) {
            timestamp = (Long)((Object)requestStartMs);
        }
        if (timestamp == -1L && requestStartMs instanceof String) {
            requestStartMsString = requestStartMs;
            if (requestStartMsString.length() == 0) {
                return;
            }
        } else {
            return;
        }
        timestamp = Long.parseLong(requestStartMsString);
        long now = System.currentTimeMillis();
        long duration = now - timestamp;
        String durationText = duration > 10000L ? (duration /= 1000L) + "sec" : duration + "ms";
        gelfMessage.addField(MDC_REQUEST_DURATION, durationText);
        gelfMessage.addField(MDC_REQUEST_END, new Date(now).toString());
    }

    public static String getSimpleClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index != -1) {
            return className.substring(index + 1);
        }
        return className;
    }
}

