/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.log4j2;

import biz.paluch.logging.gelf.LogEvent;
import biz.paluch.logging.gelf.MdcMessageField;
import biz.paluch.logging.gelf.MessageField;
import biz.paluch.logging.gelf.log4j2.PatternLogMessageField;
import java.util.Map;
import org.apache.logging.log4j.Level;

class Log4j2LogEvent
implements LogEvent {
    private org.apache.logging.log4j.core.LogEvent logEvent;

    public Log4j2LogEvent(org.apache.logging.log4j.core.LogEvent logEvent) {
        this.logEvent = logEvent;
    }

    @Override
    public String getMessage() {
        return this.logEvent.getMessage().getFormattedMessage();
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public Throwable getThrowable() {
        return this.logEvent.getThrown();
    }

    @Override
    public long getLogTimestamp() {
        return this.logEvent.getMillis();
    }

    @Override
    public String getSyslogLevel() {
        return "" + this.levelToSyslogLevel(this.logEvent.getLevel());
    }

    private int levelToSyslogLevel(Level level) {
        switch (level) {
            case FATAL: {
                return 2;
            }
            case ERROR: {
                return 3;
            }
            case WARN: {
                return 4;
            }
            case INFO: {
                return 6;
            }
        }
        return 7;
    }

    @Override
    public String getValue(MessageField field) {
        if (field instanceof MdcMessageField) {
            return this.getValue((MdcMessageField)field);
        }
        if (field instanceof PatternLogMessageField) {
            return this.getValue((PatternLogMessageField)field);
        }
        throw new UnsupportedOperationException("Cannot provide value for " + field);
    }

    public String getValue(PatternLogMessageField field) {
        return field.getPatternLayout().toSerializable(this.logEvent);
    }

    private String getValue(MdcMessageField field) {
        return this.getMdc(field.getMdcName());
    }

    @Override
    public String getMdc(String mdcName) {
        Map mdcPropertyMap = this.logEvent.getContextMap();
        if (null != mdcPropertyMap && mdcPropertyMap.containsKey(mdcName)) {
            return (String)mdcPropertyMap.get(mdcName);
        }
        return null;
    }
}

