/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf;

import biz.paluch.logging.RuntimeContainer;
import biz.paluch.logging.StackTraceFilter;
import biz.paluch.logging.gelf.LogEvent;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MessageField;
import biz.paluch.logging.gelf.PropertyProvider;
import biz.paluch.logging.gelf.StaticMessageField;
import biz.paluch.logging.gelf.Values;
import biz.paluch.logging.gelf.intern.GelfMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GelfMessageAssembler {
    private static final int MAX_SHORT_MESSAGE_LENGTH = 250;
    public static final String FIELD_MESSAGE_PARAM = "MessageParam";
    public static final String FIELD_STACK_TRACE = "StackTrace";
    private String host;
    private String originHost;
    private int port = 12201;
    private String facility;
    private boolean extractStackTrace;
    private boolean filterStackTrace;
    private int maximumMessageSize = 8192;
    private List<MessageField> fields = new ArrayList<MessageField>();
    private String timestampPattern = "yyyy-MM-dd HH:mm:ss,SSSS";

    public void initialize(PropertyProvider propertyProvider) {
        String port;
        this.host = propertyProvider.getProperty("host");
        if (this.host == null) {
            this.host = propertyProvider.getProperty("graylogHost");
        }
        if ((port = propertyProvider.getProperty("port")) == null) {
            port = propertyProvider.getProperty("graylogPort");
        }
        if (port != null) {
            this.port = Integer.parseInt(port);
        }
        this.originHost = propertyProvider.getProperty("originHost");
        this.extractStackTrace = "true".equalsIgnoreCase(propertyProvider.getProperty("extractStackTrace"));
        this.filterStackTrace = "true".equalsIgnoreCase(propertyProvider.getProperty("filterStackTrace"));
        this.setupStaticFields(propertyProvider);
        this.facility = propertyProvider.getProperty("facility");
        String messageSize = propertyProvider.getProperty("maximumMessageSize");
        if (messageSize != null) {
            this.maximumMessageSize = Integer.parseInt(messageSize);
        }
    }

    public GelfMessage createGelfMessage(LogEvent logEvent) {
        String message;
        String shortMessage = message = logEvent.getMessage();
        if (message.length() > 250) {
            shortMessage = message.substring(0, 249);
        }
        GelfMessage gelfMessage = new GelfMessage(shortMessage, message, logEvent.getLogTimestamp(), logEvent.getSyslogLevel());
        for (MessageField field : this.fields) {
            Values values = this.getValues(logEvent, field);
            if (values == null || !values.hasValues()) continue;
            for (String entryName : values.getEntryNames()) {
                String value = (String)values.getValue(entryName);
                if (value == null) continue;
                gelfMessage.addField(entryName, value);
            }
        }
        if (this.extractStackTrace) {
            this.addStackTrace(logEvent, gelfMessage);
        }
        if (logEvent.getParameters() != null) {
            for (int i = 0; i < logEvent.getParameters().length; ++i) {
                Object param = logEvent.getParameters()[i];
                gelfMessage.addField(FIELD_MESSAGE_PARAM + i, "" + param);
            }
        }
        gelfMessage.setHost(this.getOriginHost());
        if (null != this.facility) {
            gelfMessage.setFacility(this.facility);
        }
        gelfMessage.setMaximumMessageSize(this.maximumMessageSize);
        return gelfMessage;
    }

    private Values getValues(LogEvent logEvent, MessageField field) {
        if (field instanceof StaticMessageField) {
            return new Values(field.getName(), this.getValue((StaticMessageField)field));
        }
        if (field instanceof LogMessageField) {
            LogMessageField logMessageField = (LogMessageField)field;
            if (logMessageField.getNamedLogField() == LogMessageField.NamedLogField.Time) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(this.timestampPattern);
                return new Values(field.getName(), dateFormat.format(new Date(logEvent.getLogTimestamp())));
            }
            if (logMessageField.getNamedLogField() == LogMessageField.NamedLogField.Server) {
                return new Values(field.getName(), this.getOriginHost());
            }
        }
        return logEvent.getValues(field);
    }

    private String getValue(StaticMessageField field) {
        return field.getValue();
    }

    private void addStackTrace(LogEvent logEvent, GelfMessage gelfMessage) {
        Throwable thrown = logEvent.getThrowable();
        if (null != thrown) {
            if (this.filterStackTrace) {
                gelfMessage.addField(FIELD_STACK_TRACE, StackTraceFilter.getFilteredStackTrace(thrown));
            } else {
                StringWriter sw = new StringWriter();
                thrown.printStackTrace(new PrintWriter(sw));
                gelfMessage.addField(FIELD_STACK_TRACE, sw.toString());
            }
        }
    }

    private void setupStaticFields(PropertyProvider propertyProvider) {
        String property;
        int fieldNumber = 0;
        while (null != (property = propertyProvider.getProperty("additionalField." + fieldNumber))) {
            int index = property.indexOf(61);
            if (-1 != index) {
                StaticMessageField field = new StaticMessageField(property.substring(0, index), property.substring(index + 1));
                this.addField(field);
            }
            ++fieldNumber;
        }
    }

    public void addField(MessageField field) {
        this.fields.add(field);
    }

    public void addFields(Collection<? extends MessageField> fields) {
        this.fields.addAll(fields);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getOriginHost() {
        if (null == this.originHost) {
            this.originHost = RuntimeContainer.FQDN_HOSTNAME;
        }
        return this.originHost;
    }

    public void setOriginHost(String originHost) {
        this.originHost = originHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public boolean isExtractStackTrace() {
        return this.extractStackTrace;
    }

    public void setExtractStackTrace(boolean extractStackTrace) {
        this.extractStackTrace = extractStackTrace;
    }

    public boolean isFilterStackTrace() {
        return this.filterStackTrace;
    }

    public void setFilterStackTrace(boolean filterStackTrace) {
        this.filterStackTrace = filterStackTrace;
    }

    public String getTimestampPattern() {
        return this.timestampPattern;
    }

    public void setTimestampPattern(String timestampPattern) {
        this.timestampPattern = timestampPattern;
    }

    public int getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    public void setMaximumMessageSize(int maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
    }
}

