/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.jul;

import biz.paluch.logging.gelf.GelfUtil;
import biz.paluch.logging.gelf.LogEvent;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MessageField;
import biz.paluch.logging.gelf.Values;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JulLogEvent
implements LogEvent {
    private static Map<String, String> threadNameCache = new ConcurrentHashMap<String, String>();
    private LogRecord logRecord;

    public JulLogEvent(LogRecord logRecord) {
        this.logRecord = logRecord;
    }

    @Override
    public String getMessage() {
        return this.createMessage(this.logRecord);
    }

    @Override
    public Object[] getParameters() {
        return this.logRecord.getParameters();
    }

    @Override
    public Throwable getThrowable() {
        return this.logRecord.getThrown();
    }

    @Override
    public long getLogTimestamp() {
        return this.logRecord.getMillis();
    }

    @Override
    public String getSyslogLevel() {
        return "" + this.levelToSyslogLevel(this.logRecord.getLevel());
    }

    private String createMessage(LogRecord record) {
        String message = record.getMessage();
        Object[] parameters = record.getParameters();
        if (message == null) {
            message = "";
        }
        if (parameters != null && parameters.length > 0) {
            try {
                message = MessageFormat.format(message, parameters);
            }
            catch (IllegalArgumentException e) {
                message = record.getMessage();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            if (message.equals(record.getMessage())) {
                try {
                    message = String.format(message, parameters);
                }
                catch (IllegalFormatException e) {
                    message = record.getMessage();
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        return message;
    }

    private String getThreadName(LogRecord record) {
        String cacheKey = "" + record.getThreadID();
        if (threadNameCache.containsKey(cacheKey)) {
            return threadNameCache.get(cacheKey);
        }
        long threadId = record.getThreadID();
        String threadName = "" + record.getThreadID();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (long id : threadMXBean.getAllThreadIds()) {
            if (id != threadId) continue;
            ThreadInfo threadInfo = threadMXBean.getThreadInfo(id);
            if (threadInfo == null) break;
            threadName = threadInfo.getThreadName();
            break;
        }
        threadNameCache.put(cacheKey, threadName);
        return threadName;
    }

    private int levelToSyslogLevel(Level level) {
        int syslogLevel = level == Level.SEVERE ? 3 : (level == Level.WARNING ? 4 : (level == Level.INFO ? 6 : 7));
        return syslogLevel;
    }

    @Override
    public Values getValues(MessageField field) {
        if (field instanceof LogMessageField) {
            return new Values(field.getName(), this.getValue((LogMessageField)field));
        }
        throw new UnsupportedOperationException("Cannot provide value for " + field);
    }

    public String getValue(LogMessageField field) {
        switch (field.getNamedLogField()) {
            case Severity: {
                return this.logRecord.getLevel().getName();
            }
            case ThreadName: {
                return this.getThreadName(this.logRecord);
            }
            case SourceClassName: {
                return this.logRecord.getSourceClassName();
            }
            case SourceMethodName: {
                return this.logRecord.getSourceMethodName();
            }
            case SourceSimpleClassName: {
                return GelfUtil.getSimpleClassName(this.logRecord.getSourceClassName());
            }
        }
        throw new UnsupportedOperationException("Cannot provide value for " + field);
    }

    @Override
    public String getMdcValue(String mdcName) {
        return null;
    }
}

