/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.logback;

import biz.paluch.logging.gelf.DynamicMdcMessageField;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MdcGelfMessageAssembler;
import biz.paluch.logging.gelf.MdcMessageField;
import biz.paluch.logging.gelf.StaticMessageField;
import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.GelfSenderFactory;
import biz.paluch.logging.gelf.logback.LogbackLogEvent;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;

public class GelfLogbackAppender
extends AppenderBase<ILoggingEvent>
implements ErrorReporter {
    protected GelfSender gelfSender;
    protected MdcGelfMessageAssembler gelfMessageAssembler = new MdcGelfMessageAssembler();

    public GelfLogbackAppender() {
        this.gelfMessageAssembler.addFields(LogMessageField.getDefaultMapping());
    }

    protected void append(ILoggingEvent event) {
        if (event == null) {
            return;
        }
        if (null == this.gelfSender) {
            this.gelfSender = GelfSenderFactory.createSender(this.gelfMessageAssembler, this);
        }
        try {
            GelfMessage message = this.createGelfMessage(event);
            if (!message.isValid()) {
                this.reportError("GELF Message is invalid: " + message.toJson(), null);
            }
            if (null == this.gelfSender || !this.gelfSender.sendMessage(message)) {
                this.reportError("Could not send GELF message", null);
            }
        }
        catch (Exception e) {
            this.reportError("Could not send GELF message: " + e.getMessage(), e);
        }
    }

    @Override
    public void reportError(String message, Exception exception) {
        this.addError(message, exception);
    }

    protected GelfMessage createGelfMessage(ILoggingEvent loggingEvent) {
        return this.gelfMessageAssembler.createGelfMessage(new LogbackLogEvent(loggingEvent));
    }

    public void setAdditionalFields(String fieldSpec) {
        String[] properties;
        for (String field : properties = fieldSpec.split(",")) {
            int index = field.indexOf(61);
            if (-1 == index) continue;
            this.gelfMessageAssembler.addField(new StaticMessageField(field.substring(0, index), field.substring(index + 1)));
        }
    }

    public void setMdcFields(String fieldSpec) {
        String[] fields;
        for (String field : fields = fieldSpec.split(",")) {
            this.gelfMessageAssembler.addField(new MdcMessageField(field.trim(), field.trim()));
        }
    }

    public String getGraylogHost() {
        return this.gelfMessageAssembler.getHost();
    }

    public void setGraylogHost(String graylogHost) {
        this.gelfMessageAssembler.setHost(graylogHost);
    }

    public String getOriginHost() {
        return this.gelfMessageAssembler.getOriginHost();
    }

    public void setOriginHost(String originHost) {
        this.gelfMessageAssembler.setOriginHost(originHost);
    }

    public int getGraylogPort() {
        return this.gelfMessageAssembler.getPort();
    }

    public void setGraylogPort(int graylogPort) {
        this.gelfMessageAssembler.setPort(graylogPort);
    }

    public String getHost() {
        return this.gelfMessageAssembler.getHost();
    }

    public void setHost(String host) {
        this.gelfMessageAssembler.setHost(host);
    }

    public int getPort() {
        return this.gelfMessageAssembler.getPort();
    }

    public void setPort(int port) {
        this.gelfMessageAssembler.setPort(port);
    }

    public String getFacility() {
        return this.gelfMessageAssembler.getFacility();
    }

    public void setFacility(String facility) {
        this.gelfMessageAssembler.setFacility(facility);
    }

    public boolean isExtractStackTrace() {
        return this.gelfMessageAssembler.isExtractStackTrace();
    }

    public void setExtractStackTrace(boolean extractStacktrace) {
        this.gelfMessageAssembler.setExtractStackTrace(extractStacktrace);
    }

    public boolean isFilterStackTrace() {
        return this.gelfMessageAssembler.isFilterStackTrace();
    }

    public void setFilterStackTrace(boolean filterStackTrace) {
        this.gelfMessageAssembler.setFilterStackTrace(filterStackTrace);
    }

    public boolean isMdcProfiling() {
        return this.gelfMessageAssembler.isMdcProfiling();
    }

    public void setMdcProfiling(boolean mdcProfiling) {
        this.gelfMessageAssembler.setMdcProfiling(mdcProfiling);
    }

    public String getTimestampPattern() {
        return this.gelfMessageAssembler.getTimestampPattern();
    }

    public void setTimestampPattern(String timestampPattern) {
        this.gelfMessageAssembler.setTimestampPattern(timestampPattern);
    }

    public int getMaximumMessageSize() {
        return this.gelfMessageAssembler.getMaximumMessageSize();
    }

    public void setMaximumMessageSize(int maximumMessageSize) {
        this.gelfMessageAssembler.setMaximumMessageSize(maximumMessageSize);
    }

    public void setDynamicMdcFields(String fieldSpec) {
        String[] fields;
        for (String field : fields = fieldSpec.split(",")) {
            this.gelfMessageAssembler.addField(new DynamicMdcMessageField(field.trim()));
        }
    }

    public void setTestSenderClass(String testSender) {
        try {
            if (null != testSender) {
                Class<?> clazz = Class.forName(testSender);
                this.gelfSender = (GelfSender)clazz.newInstance();
            }
        }
        catch (Exception e) {
            this.reportError("Could not instantiate the testSenderClass", e);
        }
    }
}

