/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf;

import biz.paluch.logging.gelf.MessageField;
import java.util.ArrayList;
import java.util.List;

public class LogMessageField
implements MessageField {
    private String name;
    private NamedLogField namedLogField;

    public LogMessageField(String name, NamedLogField namedLogField) {
        this.namedLogField = namedLogField;
        this.name = name;
    }

    public NamedLogField getNamedLogField() {
        return this.namedLogField;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static List<LogMessageField> getDefaultMapping() {
        ArrayList<LogMessageField> result = new ArrayList<LogMessageField>();
        for (NamedLogField namedLogField : NamedLogField.values()) {
            result.add(new LogMessageField(namedLogField.fieldName, namedLogField));
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [name='").append(this.name).append('\'');
        sb.append(", namedLogField=").append((Object)this.namedLogField);
        sb.append(']');
        return sb.toString();
    }

    public static enum NamedLogField {
        Time("Time"),
        Severity("Severity"),
        ThreadName("Thread"),
        SourceClassName("SourceClassName"),
        SourceSimpleClassName("SourceSimpleClassName"),
        SourceMethodName("SourceMethodName"),
        Server("Server");

        private final String fieldName;

        private NamedLogField(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

