/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf;

import biz.paluch.logging.gelf.DynamicMdcMessageField;
import biz.paluch.logging.gelf.GelfMessageAssembler;
import biz.paluch.logging.gelf.GelfUtil;
import biz.paluch.logging.gelf.LogEvent;
import biz.paluch.logging.gelf.MdcMessageField;
import biz.paluch.logging.gelf.PropertyProvider;
import biz.paluch.logging.gelf.intern.GelfMessage;

public class MdcGelfMessageAssembler
extends GelfMessageAssembler {
    public static final String PROPERTY_MDC_PROFILING = "mdcProfiling";
    public static final String PROPERTY_MDC_FIELD = "mdcField.";
    public static final String PROPERTY_DYNAMIC_MDC_FIELD = "dynamicMdcFields.";
    private boolean mdcProfiling;

    @Override
    public void initialize(PropertyProvider propertyProvider) {
        super.initialize(propertyProvider);
        this.mdcProfiling = "true".equalsIgnoreCase(propertyProvider.getProperty(PROPERTY_MDC_PROFILING));
        this.setupMdcFields(propertyProvider);
        this.setupDynamicMdcFields(propertyProvider);
    }

    @Override
    public GelfMessage createGelfMessage(LogEvent logEvent) {
        GelfMessage gelfMessage = super.createGelfMessage(logEvent);
        if (this.mdcProfiling) {
            GelfUtil.addMdcProfiling(logEvent, gelfMessage);
        }
        return gelfMessage;
    }

    private void setupMdcFields(PropertyProvider propertyProvider) {
        String property;
        int fieldNumber = 0;
        while (null != (property = propertyProvider.getProperty(PROPERTY_MDC_FIELD + fieldNumber))) {
            MdcMessageField field = new MdcMessageField(property, property);
            this.addField(field);
            ++fieldNumber;
        }
    }

    private void setupDynamicMdcFields(PropertyProvider propertyProvider) {
        String property;
        int fieldNumber = 0;
        while (null != (property = propertyProvider.getProperty(PROPERTY_DYNAMIC_MDC_FIELD + fieldNumber))) {
            DynamicMdcMessageField field = new DynamicMdcMessageField(property);
            this.addField(field);
            ++fieldNumber;
        }
    }

    public boolean isMdcProfiling() {
        return this.mdcProfiling;
    }

    public void setMdcProfiling(boolean mdcProfiling) {
        this.mdcProfiling = mdcProfiling;
    }
}

