/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern;

import biz.paluch.logging.gelf.GelfMessageAssembler;
import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.GelfTCPSender;
import biz.paluch.logging.gelf.intern.GelfUDPSender;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;

public class GelfSenderFactory {
    public static GelfSender createSender(GelfMessageAssembler gelfMessageAssembler, ErrorReporter errorReporter) {
        if (gelfMessageAssembler.getHost() == null) {
            errorReporter.reportError("Graylog2 hostname is empty!", null);
        } else {
            try {
                return GelfSenderFactory.createSender(gelfMessageAssembler.getHost(), gelfMessageAssembler.getPort(), errorReporter);
            }
            catch (UnknownHostException e) {
                errorReporter.reportError("Unknown Graylog2 hostname:" + gelfMessageAssembler.getHost(), e);
            }
            catch (SocketException e) {
                errorReporter.reportError("Socket exception: " + e.getMessage(), e);
            }
            catch (IOException e) {
                errorReporter.reportError("IO exception: " + e.getMessage(), e);
            }
        }
        return null;
    }

    public static GelfSender createSender(String graylogHost, int graylogPort, ErrorReporter errorReporter) throws IOException {
        if (graylogHost.startsWith("tcp:")) {
            String tcpGraylogHost = graylogHost.substring(4, graylogHost.length());
            return new GelfTCPSender(tcpGraylogHost, graylogPort, errorReporter);
        }
        if (graylogHost.startsWith("udp:")) {
            String udpGraylogHost = graylogHost.substring(4, graylogHost.length());
            return new GelfUDPSender(udpGraylogHost, graylogPort, errorReporter);
        }
        return new GelfUDPSender(graylogHost, graylogPort, errorReporter);
    }
}

