/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.json.simple.JSONValue;

public class GelfMessage {
    private static final String ID_NAME = "id";
    private static final String GELF_VERSION = "1.0";
    private static final byte[] GELF_CHUNKED_ID = new byte[]{30, 15};
    private static final BigDecimal TIME_DIVISOR = new BigDecimal(1000);
    public static final String FIELD_HOST = "host";
    public static final String FIELD_SHORT_MESSAGE = "short_message";
    public static final String FIELD_FULL_MESSAGE = "full_message";
    public static final String FIELD_TIMESTAMP = "timestamp";
    public static final String FIELD_LEVEL = "level";
    public static final String FIELD_FACILITY = "facility";
    private String version = "1.0";
    private String host;
    private byte[] hostBytes = this.lastFourAsciiBytes("none");
    private String shortMessage;
    private String fullMessage;
    private long javaTimestamp;
    private String level;
    private String facility = "logstash-gelf";
    private Map<String, String> additonalFields = new HashMap<String, String>();
    private int maximumMessageSize = 8192;

    public GelfMessage() {
    }

    public GelfMessage(String shortMessage, String fullMessage, long timestamp, String level) {
        this.shortMessage = shortMessage;
        this.fullMessage = fullMessage;
        this.javaTimestamp = timestamp;
        this.level = level;
    }

    public String toJson(String additionalFieldPrefix) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FIELD_HOST, this.getHost());
        map.put(FIELD_SHORT_MESSAGE, this.getShortMessage());
        map.put(FIELD_FULL_MESSAGE, this.getFullMessage());
        map.put(FIELD_TIMESTAMP, this.getTimestamp());
        map.put(FIELD_LEVEL, this.getLevel());
        map.put(FIELD_FACILITY, this.getFacility());
        for (Map.Entry<String, String> additionalField : this.additonalFields.entrySet()) {
            Object value;
            if (ID_NAME.equals(additionalField.getKey())) continue;
            try {
                value = Double.parseDouble(additionalField.getValue());
            }
            catch (NumberFormatException ex) {
                value = additionalField.getValue();
            }
            map.put(additionalFieldPrefix + additionalField.getKey(), value);
        }
        return JSONValue.toJSONString(map);
    }

    public String toJson() {
        return this.toJson("_");
    }

    public ByteBuffer[] toUDPBuffers() {
        byte[] messageBytes = this.gzipMessage(this.toJson());
        int diagrams_length = messageBytes.length / this.maximumMessageSize;
        if (messageBytes.length % this.maximumMessageSize != 0) {
            ++diagrams_length;
        }
        ByteBuffer[] datagrams = new ByteBuffer[diagrams_length];
        if (messageBytes.length > this.maximumMessageSize) {
            this.sliceDatagrams(messageBytes, datagrams);
        } else {
            datagrams[0] = ByteBuffer.allocate(messageBytes.length);
            datagrams[0].put(messageBytes);
            datagrams[0].flip();
        }
        return datagrams;
    }

    public ByteBuffer toTCPBuffer() {
        byte[] messageBytes;
        try {
            String json = this.toJson();
            json = json + '\u0000';
            messageBytes = json.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("No UTF-8 support available.", e);
        }
        ByteBuffer buffer = ByteBuffer.allocate(messageBytes.length);
        buffer.put(messageBytes);
        buffer.flip();
        return buffer;
    }

    public ByteBuffer toAMQPBuffer() {
        byte[] messageBytes = this.gzipMessage(this.toJson());
        ByteBuffer buffer = ByteBuffer.allocate(messageBytes.length);
        buffer.put(messageBytes);
        buffer.flip();
        return buffer;
    }

    private void sliceDatagrams(byte[] messageBytes, ByteBuffer[] datagrams) {
        int messageLength = messageBytes.length;
        byte[] messageId = ByteBuffer.allocate(8).putInt(this.getCurrentMillis()).put(this.hostBytes).array();
        int num = datagrams.length;
        for (int idx = 0; idx < num; ++idx) {
            byte[] header = this.concatByteArray(GELF_CHUNKED_ID, this.concatByteArray(messageId, new byte[]{(byte)idx, (byte)num}));
            int from = idx * this.maximumMessageSize;
            int to = from + this.maximumMessageSize;
            if (to >= messageLength) {
                to = messageLength;
            }
            byte[] datagram = this.concatByteArray(header, Arrays.copyOfRange(messageBytes, from, to));
            datagrams[idx] = ByteBuffer.allocate(datagram.length);
            datagrams[idx].put(datagram);
            datagrams[idx].flip();
        }
    }

    public int getCurrentMillis() {
        return (int)System.currentTimeMillis();
    }

    private byte[] gzipMessage(String message) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            byte[] bytes;
            GZIPOutputStream stream = new GZIPOutputStream(bos);
            try {
                bytes = message.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("No UTF-8 support available.", e);
            }
            stream.write(bytes);
            stream.finish();
            stream.close();
            byte[] zipped = bos.toByteArray();
            bos.close();
            return zipped;
        }
        catch (IOException e) {
            return null;
        }
    }

    private byte[] lastFourAsciiBytes(String host) {
        String shortHost = host.length() >= 4 ? host.substring(host.length() - 4) : host;
        try {
            return shortHost.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM without ascii support?", e);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.hostBytes = this.lastFourAsciiBytes(host);
    }

    public String getShortMessage() {
        return !this.isEmpty(this.shortMessage) ? this.shortMessage : "<empty>";
    }

    public void setShortMessage(String shortMessage) {
        this.shortMessage = shortMessage;
    }

    public String getFullMessage() {
        return this.fullMessage;
    }

    public void setFullMessage(String fullMessage) {
        this.fullMessage = fullMessage;
    }

    public String getTimestamp() {
        return new BigDecimal(this.javaTimestamp).divide(TIME_DIVISOR).toPlainString();
    }

    public Long getJavaTimestamp() {
        return this.javaTimestamp;
    }

    public void setJavaTimestamp(long javaTimestamp) {
        this.javaTimestamp = javaTimestamp;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public GelfMessage addField(String key, String value) {
        this.getAdditonalFields().put(key, value);
        return this;
    }

    public Map<String, String> getAdditonalFields() {
        return this.additonalFields;
    }

    public void setAdditonalFields(Map<String, String> additonalFields) {
        this.additonalFields = additonalFields;
    }

    public boolean isValid() {
        return this.isShortOrFullMessagesExists() && !this.isEmpty(this.version) && !this.isEmpty(this.host) && !this.isEmpty(this.facility);
    }

    private boolean isShortOrFullMessagesExists() {
        return !this.isEmpty(this.shortMessage) || !this.isEmpty(this.fullMessage);
    }

    public boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    private byte[] concatByteArray(byte[] first, byte[] second) {
        byte[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public int getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    public void setMaximumMessageSize(int maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
    }

    public String getField(String fieldName) {
        return this.getAdditonalFields().get(fieldName);
    }
}

