/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import java.io.IOException;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class GelfREDISSender
implements GelfSender {
    private JedisPool jedisPool;
    private ErrorReporter errorReporter;
    private String redisKey;

    public GelfREDISSender(JedisPool jedisPool, String redisKey, ErrorReporter errorReporter) throws IOException {
        this.jedisPool = jedisPool;
        this.errorReporter = errorReporter;
        this.redisKey = redisKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(GelfMessage message) {
        if (!message.isValid()) {
            return false;
        }
        Jedis jedisClient = null;
        try {
            jedisClient = (Jedis)this.jedisPool.getResource();
            jedisClient.lpush(this.redisKey, new String[]{message.toJson("")});
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.errorReporter.reportError(e.getMessage(), new IOException("Cannot send REDIS data with key URI " + this.redisKey, e));
            boolean bl = false;
            return bl;
        }
        finally {
            if (jedisClient != null) {
                this.jedisPool.returnResource(jedisClient);
            }
        }
    }

    @Override
    public void close() {
    }
}

