/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class GelfTCPSender
implements GelfSender {
    private boolean shutdown = false;
    private InetAddress host;
    private int port;
    private Socket socket;
    private ErrorReporter errorReporter;

    public GelfTCPSender(String host, int port, ErrorReporter errorReporter) throws IOException {
        this.host = InetAddress.getByName(host);
        this.port = port;
        this.socket = new Socket(host, port);
        this.errorReporter = errorReporter;
    }

    @Override
    public boolean sendMessage(GelfMessage message) {
        if (this.shutdown || !message.isValid()) {
            return false;
        }
        try {
            if (this.socket == null) {
                this.socket = new Socket(this.host, this.port);
            }
            this.socket.getOutputStream().write(message.toTCPBuffer().array());
            return true;
        }
        catch (IOException e) {
            this.errorReporter.reportError(e.getMessage(), new IOException("Cannot send data to " + this.host + ":" + this.port, e));
            this.socket = null;
            return false;
        }
    }

    @Override
    public void close() {
        this.shutdown = true;
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            this.errorReporter.reportError(e.getMessage(), e);
        }
    }
}

