/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.logback;

import biz.paluch.logging.gelf.DynamicMdcMessageField;
import biz.paluch.logging.gelf.GelfUtil;
import biz.paluch.logging.gelf.LogEvent;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MdcMessageField;
import biz.paluch.logging.gelf.MessageField;
import biz.paluch.logging.gelf.Values;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class LogbackLogEvent
implements LogEvent {
    private ILoggingEvent loggingEvent;

    public LogbackLogEvent(ILoggingEvent loggingEvent) {
        this.loggingEvent = loggingEvent;
    }

    @Override
    public String getMessage() {
        return this.loggingEvent.getFormattedMessage();
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public Throwable getThrowable() {
        Throwable result = null;
        IThrowableProxy throwableProxy = this.loggingEvent.getThrowableProxy();
        if (null != throwableProxy && throwableProxy instanceof ThrowableProxy) {
            result = ((ThrowableProxy)throwableProxy).getThrowable();
        }
        return result;
    }

    @Override
    public long getLogTimestamp() {
        return this.loggingEvent.getTimeStamp();
    }

    @Override
    public String getSyslogLevel() {
        return this.levelToSyslogLevel(this.loggingEvent.getLevel());
    }

    public String getSourceClassName() {
        StackTraceElement calleeStackTraceElement = this.getCalleeStackTraceElement();
        if (null == calleeStackTraceElement) {
            return "";
        }
        return calleeStackTraceElement.getClassName();
    }

    private StackTraceElement getCalleeStackTraceElement() {
        StackTraceElement[] callerData = this.loggingEvent.getCallerData();
        if (null != callerData) {
            return callerData[0];
        }
        return null;
    }

    public String getSourceMethodName() {
        StackTraceElement calleeStackTraceElement = this.getCalleeStackTraceElement();
        if (null == calleeStackTraceElement) {
            return "";
        }
        return calleeStackTraceElement.getMethodName();
    }

    private String levelToSyslogLevel(Level level) {
        String result = "7";
        int intLevel = level.toInt();
        if (intLevel > 40000) {
            result = "2";
        } else if (intLevel == 40000) {
            result = "3";
        } else if (intLevel == 30000) {
            result = "4";
        } else if (intLevel == 20000) {
            result = "6";
        }
        return result;
    }

    @Override
    public Values getValues(MessageField field) {
        if (field instanceof LogMessageField) {
            return new Values(field.getName(), this.getValue((LogMessageField)field));
        }
        if (field instanceof MdcMessageField) {
            return new Values(field.getName(), this.getValue((MdcMessageField)field));
        }
        if (field instanceof DynamicMdcMessageField) {
            return this.getMdcValues((DynamicMdcMessageField)field);
        }
        throw new UnsupportedOperationException("Cannot provide value for " + field);
    }

    public String getValue(LogMessageField field) {
        switch (field.getNamedLogField()) {
            case Severity: {
                return this.loggingEvent.getLevel().toString();
            }
            case ThreadName: {
                return this.loggingEvent.getThreadName();
            }
            case SourceClassName: {
                return this.getSourceClassName();
            }
            case SourceMethodName: {
                return this.getSourceMethodName();
            }
            case SourceSimpleClassName: {
                return GelfUtil.getSimpleClassName(this.getSourceClassName());
            }
        }
        throw new UnsupportedOperationException("Cannot provide value for " + field);
    }

    private Values getMdcValues(DynamicMdcMessageField field) {
        Values result = new Values();
        Set<String> mdcNames = this.getAllMdcNames();
        Set<String> matchingMdcNames = GelfUtil.getMatchingMdcNames(field, mdcNames);
        for (String mdcName : matchingMdcNames) {
            String mdcValue = this.getMdcValue(mdcName);
            if (mdcName == null) continue;
            result.setValue(mdcName, mdcValue);
        }
        return result;
    }

    private Set<String> getAllMdcNames() {
        HashSet<String> mdcNames = new HashSet<String>();
        mdcNames.addAll(this.loggingEvent.getMDCPropertyMap().keySet());
        return mdcNames;
    }

    private String getValue(MdcMessageField field) {
        return this.getMdcValue(field.getMdcName());
    }

    @Override
    public String getMdcValue(String mdcName) {
        Map mdcPropertyMap = this.loggingEvent.getMDCPropertyMap();
        if (null != mdcPropertyMap && mdcPropertyMap.containsKey(mdcName)) {
            return (String)mdcPropertyMap.get(mdcName);
        }
        return null;
    }
}

