/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.GelfSenderConfiguration;
import biz.paluch.logging.gelf.intern.GelfSenderProvider;
import biz.paluch.logging.gelf.intern.sender.GelfREDISSender;
import biz.paluch.logging.gelf.intern.sender.RedisSenderPoolProvider;
import java.io.IOException;
import java.net.URI;
import redis.clients.jedis.JedisPool;

public class RedisGelfSenderProvider
implements GelfSenderProvider {
    @Override
    public boolean supports(String host) {
        return host.startsWith("redis:");
    }

    @Override
    public GelfSender create(GelfSenderConfiguration configuration) throws IOException {
        String graylogHost = configuration.getHost();
        URI hostUri = URI.create(graylogHost);
        int port = hostUri.getPort();
        if (port == 0) {
            port = configuration.getPort();
        }
        if (port == 0) {
            port = 6379;
        }
        JedisPool pool = RedisSenderPoolProvider.INSTANCE.getJedisPool(hostUri, port);
        return new GelfREDISSender(pool, hostUri.getFragment(), configuration.getErrorReport());
    }
}

