/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.log4j2;

import biz.paluch.logging.gelf.DynamicMdcMessageField;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MdcGelfMessageAssembler;
import biz.paluch.logging.gelf.MdcMessageField;
import biz.paluch.logging.gelf.StaticMessageField;
import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.GelfSenderFactory;
import biz.paluch.logging.gelf.log4j2.GelfDynamicMdcLogFields;
import biz.paluch.logging.gelf.log4j2.GelfLogField;
import biz.paluch.logging.gelf.log4j2.Log4j2LogEvent;
import biz.paluch.logging.gelf.log4j2.PatternLogMessageField;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Strings;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="Gelf", category="Core", elementType="appender", printObject=true)
public class GelfLogAppender
extends AbstractAppender
implements ErrorReporter {
    private static final Logger LOGGER = StatusLogger.getLogger();
    protected GelfSender gelfSender;
    private MdcGelfMessageAssembler gelfMessageAssembler;

    public GelfLogAppender(String name, Filter filter, MdcGelfMessageAssembler gelfMessageAssembler) {
        super(name, filter, null);
        this.gelfMessageAssembler = gelfMessageAssembler;
    }

    @PluginFactory
    public static GelfLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Field") GelfLogField[] fields, @PluginElement(value="DynamicMdcFields") GelfDynamicMdcLogFields[] dynamicFieldArray, @PluginAttribute(value="graylogHost") String graylogHost, @PluginAttribute(value="host") String host, @PluginAttribute(value="graylogPort") String graylogPort, @PluginAttribute(value="port") String port, @PluginAttribute(value="extractStackTrace") String extractStackTrace, @PluginAttribute(value="facility") String facility, @PluginAttribute(value="filterStackTrace") String filterStackTrace, @PluginAttribute(value="mdcProfiling") String mdcProfiling, @PluginAttribute(value="maximumMessageSize") String maximumMessageSize) {
        MdcGelfMessageAssembler mdcGelfMessageAssembler = new MdcGelfMessageAssembler();
        if (name == null) {
            LOGGER.error("No name provided for " + GelfLogAppender.class.getSimpleName());
            return null;
        }
        if (Strings.isEmpty((CharSequence)host) && Strings.isEmpty((CharSequence)graylogHost)) {
            LOGGER.error("No host provided for " + GelfLogAppender.class.getSimpleName());
            return null;
        }
        if (Strings.isNotEmpty((CharSequence)host)) {
            mdcGelfMessageAssembler.setHost(host);
        }
        if (Strings.isNotEmpty((CharSequence)graylogHost)) {
            mdcGelfMessageAssembler.setHost(graylogHost);
        }
        if (Strings.isNotEmpty((CharSequence)port)) {
            mdcGelfMessageAssembler.setPort(Integer.parseInt(port));
        }
        if (Strings.isNotEmpty((CharSequence)graylogPort)) {
            mdcGelfMessageAssembler.setPort(Integer.parseInt(graylogPort));
        }
        if (facility != null) {
            mdcGelfMessageAssembler.setFacility(facility);
        }
        if (extractStackTrace != null) {
            mdcGelfMessageAssembler.setExtractStackTrace(extractStackTrace.equals("true"));
        }
        if (filterStackTrace != null) {
            mdcGelfMessageAssembler.setFilterStackTrace(filterStackTrace.equals("true"));
        }
        if (mdcProfiling != null) {
            mdcGelfMessageAssembler.setMdcProfiling(mdcProfiling.equals("true"));
        }
        if (maximumMessageSize != null) {
            mdcGelfMessageAssembler.setMaximumMessageSize(Integer.parseInt(maximumMessageSize));
        }
        GelfLogAppender.configureFields(mdcGelfMessageAssembler, fields, dynamicFieldArray);
        GelfLogAppender result = new GelfLogAppender(name, filter, mdcGelfMessageAssembler);
        return result;
    }

    private static void configureFields(MdcGelfMessageAssembler mdcGelfMessageAssembler, GelfLogField[] fields, GelfDynamicMdcLogFields[] dynamicFieldArray) {
        if (fields == null) {
            mdcGelfMessageAssembler.addFields(LogMessageField.getDefaultMapping());
            return;
        }
        for (GelfLogField field : fields) {
            if (Strings.isNotEmpty((CharSequence)field.getMdc())) {
                mdcGelfMessageAssembler.addField(new MdcMessageField(field.getName(), field.getMdc()));
            }
            if (Strings.isNotEmpty((CharSequence)field.getLiteral())) {
                mdcGelfMessageAssembler.addField(new StaticMessageField(field.getName(), field.getLiteral()));
            }
            if (field.getPatternLayout() == null) continue;
            mdcGelfMessageAssembler.addField(new PatternLogMessageField(field.getName(), null, field.getPatternLayout()));
        }
        if (dynamicFieldArray != null) {
            for (GelfDynamicMdcLogFields gelfDynamicMdcLogFields : dynamicFieldArray) {
                mdcGelfMessageAssembler.addField(new DynamicMdcMessageField(gelfDynamicMdcLogFields.getRegex()));
            }
        }
    }

    public void append(LogEvent event) {
        if (event == null) {
            return;
        }
        try {
            GelfMessage message = this.createGelfMessage(event);
            if (!message.isValid()) {
                this.reportError("GELF Message is invalid: " + message.toJson(), null);
            }
            if (null == this.gelfSender || !this.gelfSender.sendMessage(message)) {
                this.reportError("Could not send GELF message", null);
            }
        }
        catch (Exception e) {
            this.reportError("Could not send GELF message: " + e.getMessage(), e);
        }
    }

    protected GelfMessage createGelfMessage(LogEvent logEvent) {
        return this.gelfMessageAssembler.createGelfMessage(new Log4j2LogEvent(logEvent));
    }

    @Override
    public void reportError(String message, Exception exception) {
        LOGGER.error(message, new Object[]{exception, 0});
    }

    public void stop() {
        if (null != this.gelfSender) {
            this.gelfSender.close();
            this.gelfSender = null;
        }
        super.stop();
    }

    public void start() {
        if (null == this.gelfSender) {
            this.gelfSender = GelfSenderFactory.createSender(this.gelfMessageAssembler, this);
        }
        super.start();
    }
}

