/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging;

import biz.paluch.logging.gelf.intern.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class StackTraceFilter {
    public static final String FILTER_SETTINGS = "/" + StackTraceFilter.class.getSimpleName() + ".packages";
    private static final String INDENT = "\t";
    private static Set<String> suppressedPackages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSetttings(String resourceName) {
        InputStream is = null;
        try {
            is = StackTraceFilter.getStream(resourceName);
            if (is == null) {
                System.out.println("No " + resourceName + " resource present, using defaults");
                suppressedPackages = new HashSet<String>(StackTraceFilter.getDefaults());
            } else {
                Properties p = new Properties();
                p.load(is);
                suppressedPackages = p.keySet();
            }
        }
        catch (IOException e) {
            System.out.println("Could not parse " + resourceName + " resource, using defaults");
            suppressedPackages = new HashSet<String>(StackTraceFilter.getDefaults());
        }
        finally {
            Closer.close(is);
        }
    }

    private static InputStream getStream(String resourceName) {
        Thread thread = Thread.currentThread();
        InputStream is = StackTraceFilter.class.getResourceAsStream(resourceName);
        if (is == null && thread.getContextClassLoader() != null) {
            is = thread.getContextClassLoader().getResourceAsStream(resourceName);
        }
        return is;
    }

    public static List<String> getDefaults() {
        return Arrays.asList("org.h2", "org.apache.catalina", "org.apache.coyote", "org.apache.tomcat", "com.arjuna", "org.apache.cxf", "org.hibernate", "org.junit", "org.jboss", "java.lang.reflect.Method", "sun.", "com.sun", "org.eclipse", "junit.framework", "com.sun.faces", "javax.faces", "org.richfaces", "org.apache.el", "javax.servlet");
    }

    private StackTraceFilter() {
    }

    public static String getFilteredStackTrace(Throwable t) {
        return StackTraceFilter.getFilteredStackTrace(t, true);
    }

    public static String getFilteredStackTrace(Throwable t, boolean shouldFilter) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        StackTraceFilter.writeCleanStackTrace(t, pw, shouldFilter);
        return sw.getBuffer().toString();
    }

    private static void writeCleanStackTrace(Throwable t, PrintWriter s, boolean wantsFilter) {
        s.print("Exception: ");
        StackTraceFilter.printExceptionChain(t, s);
        HashSet<String> skippedPackages = new HashSet<String>();
        int skippedLines = 0;
        boolean shouldFilter = wantsFilter;
        boolean first = true;
        for (StackTraceElement traceElement : StackTraceFilter.getBottomThrowable(t).getStackTrace()) {
            String forbiddenPackageName = null;
            if (shouldFilter && !first) {
                forbiddenPackageName = StackTraceFilter.tryGetForbiddenPackageName(traceElement);
            }
            first = false;
            if (forbiddenPackageName == null) {
                if (!skippedPackages.isEmpty()) {
                    s.println(StackTraceFilter.getSkippedPackagesMessage(skippedPackages, skippedLines));
                }
                s.println("\tat " + traceElement);
                skippedPackages.clear();
                skippedLines = 0;
                continue;
            }
            ++skippedLines;
            skippedPackages.add(forbiddenPackageName);
        }
        if (skippedLines > 0) {
            s.println(StackTraceFilter.getSkippedPackagesMessage(skippedPackages, skippedLines));
        }
    }

    private static String getSkippedPackagesMessage(Set<String> skippedPackages, int skippedLines) {
        return "\t\t" + skippedLines + " line" + (skippedLines == 1 ? "" : "s") + " skipped for " + skippedPackages;
    }

    private static Throwable getBottomThrowable(Throwable t) {
        Throwable result = t;
        while (result.getCause() != null) {
            result = result.getCause();
        }
        return result;
    }

    private static void printExceptionChain(Throwable t, PrintWriter s) {
        s.println(t);
        if (t.getCause() != null) {
            s.print("Caused by: ");
            StackTraceFilter.printExceptionChain(t.getCause(), s);
        }
    }

    private static String tryGetForbiddenPackageName(StackTraceElement traceElement) {
        String classAndMethod = traceElement.getClassName() + "." + traceElement.getMethodName();
        for (String pkg : suppressedPackages) {
            if (!classAndMethod.startsWith(pkg)) continue;
            return pkg;
        }
        return null;
    }

    static {
        StackTraceFilter.loadSetttings(FILTER_SETTINGS);
    }
}

