/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.jboss7;

import biz.paluch.logging.gelf.DynamicMdcMessageField;
import biz.paluch.logging.gelf.GelfUtil;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MdcMessageField;
import biz.paluch.logging.gelf.MessageField;
import biz.paluch.logging.gelf.Values;
import biz.paluch.logging.gelf.jul.JulLogEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.LogRecord;
import org.apache.log4j.NDC;
import org.slf4j.MDC;

public class JBoss7JulLogEvent
extends JulLogEvent {
    public JBoss7JulLogEvent(LogRecord logRecord) {
        super(logRecord);
    }

    @Override
    public Values getValues(MessageField field) {
        if (field instanceof MdcMessageField) {
            return new Values(field.getName(), this.getValue((MdcMessageField)field));
        }
        if (field instanceof DynamicMdcMessageField) {
            return this.getMdcValues((DynamicMdcMessageField)field);
        }
        return super.getValues(field);
    }

    @Override
    public String getValue(LogMessageField field) {
        switch (field.getNamedLogField()) {
            case NDC: {
                String ndc = NDC.get();
                if (ndc != null && !"".equals(ndc)) {
                    return ndc;
                }
                return null;
            }
        }
        return super.getValue(field);
    }

    private Values getMdcValues(DynamicMdcMessageField field) {
        Values result = new Values();
        Set<String> mdcNames = this.getAllMdcNames();
        Set<String> matchingMdcNames = GelfUtil.getMatchingMdcNames(field, mdcNames);
        for (String mdcName : matchingMdcNames) {
            String mdcValue = this.getMdcValue(mdcName);
            if (mdcName == null) continue;
            result.setValue(mdcName, mdcValue);
        }
        return result;
    }

    private Set<String> getAllMdcNames() {
        HashSet<String> mdcNames = new HashSet<String>();
        if (org.apache.log4j.MDC.getContext() != null) {
            mdcNames.addAll(org.apache.log4j.MDC.getContext().keySet());
        }
        if (MDC.getCopyOfContextMap() != null) {
            mdcNames.addAll(MDC.getCopyOfContextMap().keySet());
        }
        return mdcNames;
    }

    private String getValue(MdcMessageField field) {
        return this.getMdcValue(field.getMdcName());
    }

    @Override
    public String getMdcValue(String mdcName) {
        Object value = org.apache.log4j.MDC.get((String)mdcName);
        if (value != null) {
            return value.toString();
        }
        String slf4jValue = MDC.get((String)mdcName);
        return slf4jValue;
    }

    @Override
    public Set<String> getMdcNames() {
        return this.getAllMdcNames();
    }
}

