/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.Closer;
import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class GelfTCPSender
implements GelfSender {
    private boolean shutdown = false;
    private InetAddress host;
    private int port;
    private int connectTimeoutMs;
    private int readTimeoutMs;
    private Socket socket;
    private ErrorReporter errorReporter;

    public GelfTCPSender(String host, int port, int connectTimeoutMs, int readTimeoutMs, ErrorReporter errorReporter) throws IOException {
        this.host = InetAddress.getByName(host);
        this.port = port;
        this.errorReporter = errorReporter;
        this.connectTimeoutMs = connectTimeoutMs;
        this.readTimeoutMs = readTimeoutMs;
    }

    @Override
    public boolean sendMessage(GelfMessage message) {
        if (this.shutdown) {
            return false;
        }
        try {
            if (this.socket == null) {
                this.socket = this.createSocket();
            }
            this.socket.getOutputStream().write(message.toTCPBuffer().array());
            return true;
        }
        catch (IOException e) {
            this.errorReporter.reportError(e.getMessage(), new IOException("Cannot send data to " + this.host + ":" + this.port, e));
            this.socket = null;
            return false;
        }
    }

    protected Socket createSocket() throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(this.readTimeoutMs);
        socket.connect(new InetSocketAddress(this.host, this.port), this.connectTimeoutMs);
        return socket;
    }

    @Override
    public void close() {
        this.shutdown = true;
        Closer.close(this.socket);
    }
}

