/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

enum RedisSenderPoolProvider {
    INSTANCE;

    private Map<String, JedisPool> pools = new HashMap<String, JedisPool>();

    public synchronized JedisPool getJedisPool(URI hostURI, int configuredPort) {
        return this.getJedisPool(hostURI, configuredPort, 2000);
    }

    public synchronized JedisPool getJedisPool(URI hostURI, int configuredPort, int timeoutMs) {
        String lowerCasedConnectionString = hostURI.toString().toLowerCase();
        String cleanConnectionString = lowerCasedConnectionString.substring(0, lowerCasedConnectionString.length() - hostURI.getFragment().length());
        if (!this.pools.containsKey(cleanConnectionString)) {
            String password = hostURI.getUserInfo() != null ? hostURI.getUserInfo().split(":", 2)[1] : null;
            int database = 0;
            if (hostURI.getPath() != null && hostURI.getPath().length() > 1) {
                database = Integer.parseInt(hostURI.getPath().split("/", 2)[1]);
            }
            int port = hostURI.getPort() > 0 ? hostURI.getPort() : configuredPort;
            JedisPool newPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), hostURI.getHost(), port, timeoutMs, password, database);
            this.pools.put(cleanConnectionString, newPool);
        }
        return this.pools.get(cleanConnectionString);
    }
}

