/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Pool;

enum RedisSenderPoolProvider {
    STANDALONE{
        private Map<String, JedisPool> standalonePools = new HashMap<String, JedisPool>();

        @Override
        public String getScheme() {
            return "redis";
        }

        @Override
        public synchronized Pool<Jedis> getJedisPool(URI hostURI, int configuredPort, int timeoutMs) {
            String lowerCasedConnectionString = hostURI.toString().toLowerCase();
            String cleanConnectionString = lowerCasedConnectionString.substring(0, lowerCasedConnectionString.length() - hostURI.getFragment().length());
            if (!this.standalonePools.containsKey(cleanConnectionString)) {
                String password = hostURI.getUserInfo() != null ? hostURI.getUserInfo().split(":", 2)[1] : null;
                int database = 0;
                if (hostURI.getPath() != null && hostURI.getPath().length() > 1) {
                    database = Integer.parseInt(hostURI.getPath().split("/", 2)[1]);
                }
                int port = hostURI.getPort() > 0 ? hostURI.getPort() : configuredPort;
                JedisPool newPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), hostURI.getHost(), port, timeoutMs, password, database);
                this.standalonePools.put(cleanConnectionString, newPool);
            }
            return (Pool)this.standalonePools.get(cleanConnectionString);
        }
    }
    ,
    SENTINEL{
        public static final String MASTER_ID = "masterId";
        private Map<String, JedisSentinelPool> sentinelPools = new HashMap<String, JedisSentinelPool>();

        @Override
        public String getScheme() {
            return "redis-sentinel";
        }

        @Override
        public Pool<Jedis> getJedisPool(URI hostURI, int configuredPort, int timeoutMs) {
            String lowerCasedConnectionString = hostURI.toString().toLowerCase();
            String cleanConnectionString = lowerCasedConnectionString.substring(0, lowerCasedConnectionString.length() - hostURI.getFragment().length());
            Set<String> sentinels = this.getSentinels(hostURI);
            String masterName = this.getMasterName(hostURI);
            if (!this.sentinelPools.containsKey(cleanConnectionString)) {
                String password = hostURI.getUserInfo() != null ? hostURI.getUserInfo().split(":", 2)[1] : null;
                int database = 0;
                if (hostURI.getPath() != null && hostURI.getPath().length() > 1) {
                    database = Integer.parseInt(hostURI.getPath().split("/", 2)[1]);
                }
                JedisSentinelPool newPool = new JedisSentinelPool(masterName, sentinels, (GenericObjectPoolConfig)new JedisPoolConfig(), timeoutMs, password, database);
                this.sentinelPools.put(cleanConnectionString, newPool);
            }
            return (Pool)this.sentinelPools.get(cleanConnectionString);
        }

        protected String getMasterName(URI hostURI) {
            String masterName = "master";
            if (hostURI.getQuery() != null) {
                String[] keyValues;
                for (String keyValue : keyValues = hostURI.getQuery().split("\\&")) {
                    String[] parts = keyValue.split("\\=");
                    if (parts.length != 2 || !parts[0].equals(MASTER_ID)) continue;
                    masterName = parts[1].trim();
                }
            }
            return masterName;
        }

        protected Set<String> getSentinels(URI hostURI) {
            String[] sentinelHostNames;
            HashSet<String> sentinels = new HashSet<String>();
            for (String sentinelHostName : sentinelHostNames = hostURI.getHost().split("\\,")) {
                if (sentinelHostName.contains(":")) {
                    sentinels.add(sentinelHostName);
                    continue;
                }
                if (hostURI.getPort() <= 0) continue;
                sentinels.add(sentinelHostName + ":" + hostURI.getPort());
            }
            return sentinels;
        }
    };


    public abstract String getScheme();

    public abstract Pool<Jedis> getJedisPool(URI var1, int var2, int var3);

    public static Pool<Jedis> getJedisPool(URI hostURI, int configuredPort) {
        for (RedisSenderPoolProvider provider : RedisSenderPoolProvider.values()) {
            if (!provider.getScheme().equals(hostURI.getScheme())) continue;
            return provider.getJedisPool(hostURI, configuredPort, 2000);
        }
        throw new IllegalArgumentException("Scheme " + hostURI.getScheme() + " not supported");
    }
}

