/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.lambdaworks.redis.JavaRuntime;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Constructor;
import java.net.SocketAddress;
import java.util.concurrent.Callable;

class EpollProvider {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollProvider.class);
    public static final Class<EventLoopGroup> epollEventLoopGroupClass = EpollProvider.getClass("io.netty.channel.epoll.EpollEventLoopGroup");
    public static final Class<Channel> epollDomainSocketChannelClass = EpollProvider.getClass("io.netty.channel.epoll.EpollDomainSocketChannel");
    public static final Class<SocketAddress> domainSocketAddressClass = EpollProvider.getClass("io.netty.channel.unix.DomainSocketAddress");

    EpollProvider() {
    }

    private static <T> Class<T> getClass(String className) {
        try {
            return JavaRuntime.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.debug("Cannot load class " + className, (Throwable)e);
            return null;
        }
    }

    static void checkForEpollLibrary() {
        Preconditions.checkState((domainSocketAddressClass != null && epollDomainSocketChannelClass != null ? 1 : 0) != 0, (Object)"Cannot connect using sockets without the optional netty-transport-native-epoll library on the class path");
    }

    static SocketAddress newSocketAddress(String socketPath) {
        return EpollProvider.get(() -> {
            Constructor<SocketAddress> constructor = domainSocketAddressClass.getConstructor(String.class);
            return constructor.newInstance(socketPath);
        });
    }

    static EventLoopGroup newEventLoopGroup(int nThreads) {
        return EpollProvider.get(() -> {
            Constructor<EventLoopGroup> constructor = epollEventLoopGroupClass.getConstructor(Integer.TYPE);
            return constructor.newInstance(nThreads);
        });
    }

    private static <V> V get(Callable<V> supplier) {
        try {
            return supplier.call();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        if (epollDomainSocketChannelClass == null || epollEventLoopGroupClass == null) {
            logger.debug("Starting without optional Epoll library");
        }
    }
}

