/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

public class JavaRuntime {
    public static final boolean AT_LEAST_JDK_8 = JavaRuntime.isPresent("java.lang.FunctionalInterface");

    protected static boolean isPresent(String className) {
        try {
            JavaRuntime.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static Class<?> forName(String className) throws ClassNotFoundException {
        return JavaRuntime.forName(className, JavaRuntime.getDefaultClassLoader());
    }

    private static Class<?> forName(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String innerClassName = className.substring(0, lastDotIndex) + '$' + className.substring(lastDotIndex + 1);
                try {
                    return classLoader.loadClass(innerClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = JavaRuntime.class.getClassLoader();
        }
        return cl;
    }
}

