/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.RedisCommandExecutionException;
import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisCommandTimeoutException;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class LettuceFutures {
    private LettuceFutures() {
    }

    public static boolean awaitAll(long timeout, TimeUnit unit, Future<?> ... futures) {
        boolean complete;
        try {
            long nanos = unit.toNanos(timeout);
            long time = System.nanoTime();
            for (Future<?> f : futures) {
                if (nanos < 0L) {
                    return false;
                }
                f.get(nanos, TimeUnit.NANOSECONDS);
                long now = System.nanoTime();
                nanos -= now - time;
                time = now;
            }
            complete = true;
        }
        catch (TimeoutException e) {
            complete = false;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RedisCommandExecutionException) {
                throw new RedisCommandExecutionException(e.getCause().getMessage(), e.getCause());
            }
            throw new RedisException(e.getCause());
        }
        catch (Exception e) {
            throw new RedisCommandInterruptedException(e);
        }
        return complete;
    }

    public static <T> T awaitOrCancel(RedisFuture<T> cmd, long timeout, TimeUnit unit) {
        return LettuceFutures.await(timeout, unit, cmd);
    }

    @Deprecated
    public static <T> T await(long timeout, TimeUnit unit, RedisFuture<T> cmd) {
        try {
            if (!cmd.await(timeout, unit)) {
                cmd.cancel(true);
                throw new RedisCommandTimeoutException();
            }
            return (T)cmd.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RedisCommandInterruptedException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RedisCommandExecutionException) {
                throw new RedisCommandExecutionException(e.getCause().getMessage(), e.getCause());
            }
            throw new RedisException(e.getCause());
        }
    }
}

